/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ApplicationAttribute;
import software.amazon.awssdk.services.appstream.model.ApplicationAttributesCopier;
import software.amazon.awssdk.services.appstream.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::name)).setter(UpdateApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::displayName)).setter(UpdateApplicationRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::description)).setter(UpdateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<S3Location> ICON_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IconS3Location").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::iconS3Location)).setter(UpdateApplicationRequest.setter(Builder::iconS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconS3Location").build()}).build();
    private static final SdkField<String> LAUNCH_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchPath").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::launchPath)).setter(UpdateApplicationRequest.setter(Builder::launchPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPath").build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkingDirectory").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::workingDirectory)).setter(UpdateApplicationRequest.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()}).build();
    private static final SdkField<String> LAUNCH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchParameters").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::launchParameters)).setter(UpdateApplicationRequest.setter(Builder::launchParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchParameters").build()}).build();
    private static final SdkField<String> APP_BLOCK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppBlockArn").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::appBlockArn)).setter(UpdateApplicationRequest.setter(Builder::appBlockArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockArn").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributesToDelete").getter(UpdateApplicationRequest.getter(UpdateApplicationRequest::attributesToDeleteAsStrings)).setter(UpdateApplicationRequest.setter(Builder::attributesToDeleteWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ICON_S3_LOCATION_FIELD, LAUNCH_PATH_FIELD, WORKING_DIRECTORY_FIELD, LAUNCH_PARAMETERS_FIELD, APP_BLOCK_ARN_FIELD, ATTRIBUTES_TO_DELETE_FIELD));
    private final String name;
    private final String displayName;
    private final String description;
    private final S3Location iconS3Location;
    private final String launchPath;
    private final String workingDirectory;
    private final String launchParameters;
    private final String appBlockArn;
    private final List<String> attributesToDelete;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.iconS3Location = builder.iconS3Location;
        this.launchPath = builder.launchPath;
        this.workingDirectory = builder.workingDirectory;
        this.launchParameters = builder.launchParameters;
        this.appBlockArn = builder.appBlockArn;
        this.attributesToDelete = builder.attributesToDelete;
    }

    public final String name() {
        return this.name;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final S3Location iconS3Location() {
        return this.iconS3Location;
    }

    public final String launchPath() {
        return this.launchPath;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final String launchParameters() {
        return this.launchParameters;
    }

    public final String appBlockArn() {
        return this.appBlockArn;
    }

    public final List<ApplicationAttribute> attributesToDelete() {
        return ApplicationAttributesCopier.copyStringToEnum(this.attributesToDelete);
    }

    public final boolean hasAttributesToDelete() {
        return this.attributesToDelete != null && !(this.attributesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> attributesToDeleteAsStrings() {
        return this.attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.appBlockArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributesToDelete() ? this.attributesToDeleteAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.iconS3Location(), other.iconS3Location()) && Objects.equals(this.launchPath(), other.launchPath()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.launchParameters(), other.launchParameters()) && Objects.equals(this.appBlockArn(), other.appBlockArn()) && this.hasAttributesToDelete() == other.hasAttributesToDelete() && Objects.equals(this.attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("IconS3Location", (Object)this.iconS3Location()).add("LaunchPath", (Object)this.launchPath()).add("WorkingDirectory", (Object)this.workingDirectory()).add("LaunchParameters", (Object)this.launchParameters()).add("AppBlockArn", (Object)this.appBlockArn()).add("AttributesToDelete", this.hasAttributesToDelete() ? this.attributesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IconS3Location": {
                return Optional.ofNullable(clazz.cast(this.iconS3Location()));
            }
            case "LaunchPath": {
                return Optional.ofNullable(clazz.cast(this.launchPath()));
            }
            case "WorkingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "LaunchParameters": {
                return Optional.ofNullable(clazz.cast(this.launchParameters()));
            }
            case "AppBlockArn": {
                return Optional.ofNullable(clazz.cast(this.appBlockArn()));
            }
            case "AttributesToDelete": {
                return Optional.ofNullable(clazz.cast(this.attributesToDeleteAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationRequest, T> g) {
        return obj -> g.apply((UpdateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String displayName;
        private String description;
        private S3Location iconS3Location;
        private String launchPath;
        private String workingDirectory;
        private String launchParameters;
        private String appBlockArn;
        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            this.name(model.name);
            this.displayName(model.displayName);
            this.description(model.description);
            this.iconS3Location(model.iconS3Location);
            this.launchPath(model.launchPath);
            this.workingDirectory(model.workingDirectory);
            this.launchParameters(model.launchParameters);
            this.appBlockArn(model.appBlockArn);
            this.attributesToDeleteWithStrings(model.attributesToDelete);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final S3Location.Builder getIconS3Location() {
            return this.iconS3Location != null ? this.iconS3Location.toBuilder() : null;
        }

        public final void setIconS3Location(S3Location.BuilderImpl iconS3Location) {
            this.iconS3Location = iconS3Location != null ? iconS3Location.build() : null;
        }

        @Override
        public final Builder iconS3Location(S3Location iconS3Location) {
            this.iconS3Location = iconS3Location;
            return this;
        }

        public final String getLaunchPath() {
            return this.launchPath;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final String getLaunchParameters() {
            return this.launchParameters;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        @Override
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public final String getAppBlockArn() {
            return this.appBlockArn;
        }

        public final void setAppBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
        }

        @Override
        public final Builder appBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
            return this;
        }

        public final Collection<String> getAttributesToDelete() {
            if (this.attributesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributesToDelete;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = ApplicationAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = ApplicationAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String ... attributesToDelete) {
            this.attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<ApplicationAttribute> attributesToDelete) {
            this.attributesToDelete = ApplicationAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(ApplicationAttribute ... attributesToDelete) {
            this.attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder iconS3Location(S3Location var1);

        default public Builder iconS3Location(Consumer<S3Location.Builder> iconS3Location) {
            return this.iconS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(iconS3Location)).build());
        }

        public Builder launchPath(String var1);

        public Builder workingDirectory(String var1);

        public Builder launchParameters(String var1);

        public Builder appBlockArn(String var1);

        public Builder attributesToDeleteWithStrings(Collection<String> var1);

        public Builder attributesToDeleteWithStrings(String ... var1);

        public Builder attributesToDelete(Collection<ApplicationAttribute> var1);

        public Builder attributesToDelete(ApplicationAttribute ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

