/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceResponse extends AppRunnerResponse implements
        ToCopyableBuilder<CreateServiceResponse.Builder, CreateServiceResponse> {
    private static final SdkField<Service> SERVICE_FIELD = SdkField.<Service> builder(MarshallingType.SDK_POJO)
            .memberName("Service").getter(getter(CreateServiceResponse::service)).setter(setter(Builder::service))
            .constructor(Service::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(CreateServiceResponse::operationId)).setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD,
            OPERATION_ID_FIELD));

    private final Service service;

    private final String operationId;

    private CreateServiceResponse(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * A description of the App Runner service that's created by this request.
     * </p>
     * 
     * @return A description of the App Runner service that's created by this request.
     */
    public final Service service() {
        return service;
    }

    /**
     * <p>
     * The unique ID of the asynchronous operation that this request started. You can use it combined with the <a
     * href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a> call to track
     * the operation's progress.
     * </p>
     * 
     * @return The unique ID of the asynchronous operation that this request started. You can use it combined with the
     *         <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a>
     *         call to track the operation's progress.
     */
    public final String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceResponse)) {
            return false;
        }
        CreateServiceResponse other = (CreateServiceResponse) obj;
        return Objects.equals(service(), other.service()) && Objects.equals(operationId(), other.operationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceResponse").add("Service", service()).add("OperationId", operationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceResponse, T> g) {
        return obj -> g.apply((CreateServiceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceResponse> {
        /**
         * <p>
         * A description of the App Runner service that's created by this request.
         * </p>
         * 
         * @param service
         *        A description of the App Runner service that's created by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Service service);

        /**
         * <p>
         * A description of the App Runner service that's created by this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link Service.Builder} avoiding the need to
         * create one manually via {@link Service#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Service.Builder#build()} is called immediately and its result is
         * passed to {@link #service(Service)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link Service.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(Service)
         */
        default Builder service(Consumer<Service.Builder> service) {
            return service(Service.builder().applyMutation(service).build());
        }

        /**
         * <p>
         * The unique ID of the asynchronous operation that this request started. You can use it combined with the <a
         * href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a> call to
         * track the operation's progress.
         * </p>
         * 
         * @param operationId
         *        The unique ID of the asynchronous operation that this request started. You can use it combined with
         *        the <a
         *        href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListOperations.html">ListOperations</a>
         *        call to track the operation's progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private Service service;

        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceResponse model) {
            super(model);
            service(model.service);
            operationId(model.operationId);
        }

        public final Service.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        @Override
        public CreateServiceResponse build() {
            return new CreateServiceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
