/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the path to rewrite.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpGatewayRoutePathRewrite implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpGatewayRoutePathRewrite.Builder, HttpGatewayRoutePathRewrite> {
    private static final SdkField<String> EXACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("exact")
            .getter(getter(HttpGatewayRoutePathRewrite::exact)).setter(setter(Builder::exact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exact").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXACT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exact;

    private HttpGatewayRoutePathRewrite(BuilderImpl builder) {
        this.exact = builder.exact;
    }

    /**
     * <p>
     * The exact path to rewrite.
     * </p>
     * 
     * @return The exact path to rewrite.
     */
    public final String exact() {
        return exact;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exact());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpGatewayRoutePathRewrite)) {
            return false;
        }
        HttpGatewayRoutePathRewrite other = (HttpGatewayRoutePathRewrite) obj;
        return Objects.equals(exact(), other.exact());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpGatewayRoutePathRewrite").add("Exact", exact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exact":
            return Optional.ofNullable(clazz.cast(exact()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpGatewayRoutePathRewrite, T> g) {
        return obj -> g.apply((HttpGatewayRoutePathRewrite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpGatewayRoutePathRewrite> {
        /**
         * <p>
         * The exact path to rewrite.
         * </p>
         * 
         * @param exact
         *        The exact path to rewrite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exact(String exact);
    }

    static final class BuilderImpl implements Builder {
        private String exact;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpGatewayRoutePathRewrite model) {
            exact(model.exact);
        }

        public final String getExact() {
            return exact;
        }

        public final void setExact(String exact) {
            this.exact = exact;
        }

        @Override
        public final Builder exact(String exact) {
            this.exact = exact;
            return this;
        }

        @Override
        public HttpGatewayRoutePathRewrite build() {
            return new HttpGatewayRoutePathRewrite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
