/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.TcpRouteAction;
import software.amazon.awssdk.services.appmesh.model.TcpRouteMatch;
import software.amazon.awssdk.services.appmesh.model.TcpTimeout;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TcpRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TcpRoute> {
    private static final SdkField<TcpRouteAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(TcpRoute.getter(TcpRoute::action)).setter(TcpRoute.setter(Builder::action)).constructor(TcpRouteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<TcpRouteMatch> MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("match").getter(TcpRoute.getter(TcpRoute::match)).setter(TcpRoute.setter(Builder::match)).constructor(TcpRouteMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()}).build();
    private static final SdkField<TcpTimeout> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeout").getter(TcpRoute.getter(TcpRoute::timeout)).setter(TcpRoute.setter(Builder::timeout)).constructor(TcpTimeout::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD, TIMEOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final TcpRouteAction action;
    private final TcpRouteMatch match;
    private final TcpTimeout timeout;

    private TcpRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
        this.timeout = builder.timeout;
    }

    public final TcpRouteAction action() {
        return this.action;
    }

    public final TcpRouteMatch match() {
        return this.match;
    }

    public final TcpTimeout timeout() {
        return this.timeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.match());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TcpRoute)) {
            return false;
        }
        TcpRoute other = (TcpRoute)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.match(), other.match()) && Objects.equals(this.timeout(), other.timeout());
    }

    public final String toString() {
        return ToString.builder((String)"TcpRoute").add("Action", (Object)this.action()).add("Match", (Object)this.match()).add("Timeout", (Object)this.timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "match": {
                return Optional.ofNullable(clazz.cast(this.match()));
            }
            case "timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TcpRoute, T> g) {
        return obj -> g.apply((TcpRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TcpRouteAction action;
        private TcpRouteMatch match;
        private TcpTimeout timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(TcpRoute model) {
            this.action(model.action);
            this.match(model.match);
            this.timeout(model.timeout);
        }

        public final TcpRouteAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(TcpRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(TcpRouteAction action) {
            this.action = action;
            return this;
        }

        public final TcpRouteMatch.Builder getMatch() {
            return this.match != null ? this.match.toBuilder() : null;
        }

        public final void setMatch(TcpRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(TcpRouteMatch match) {
            this.match = match;
            return this;
        }

        public final TcpTimeout.Builder getTimeout() {
            return this.timeout != null ? this.timeout.toBuilder() : null;
        }

        public final void setTimeout(TcpTimeout.BuilderImpl timeout) {
            this.timeout = timeout != null ? timeout.build() : null;
        }

        @Override
        public final Builder timeout(TcpTimeout timeout) {
            this.timeout = timeout;
            return this;
        }

        public TcpRoute build() {
            return new TcpRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TcpRoute> {
        public Builder action(TcpRouteAction var1);

        default public Builder action(Consumer<TcpRouteAction.Builder> action) {
            return this.action((TcpRouteAction)((TcpRouteAction.Builder)TcpRouteAction.builder().applyMutation(action)).build());
        }

        public Builder match(TcpRouteMatch var1);

        default public Builder match(Consumer<TcpRouteMatch.Builder> match) {
            return this.match((TcpRouteMatch)((TcpRouteMatch.Builder)TcpRouteMatch.builder().applyMutation(match)).build());
        }

        public Builder timeout(TcpTimeout var1);

        default public Builder timeout(Consumer<TcpTimeout.Builder> timeout) {
            return this.timeout((TcpTimeout)((TcpTimeout.Builder)TcpTimeout.builder().applyMutation(timeout)).build());
        }
    }
}

