/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkloadConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkloadConfiguration.Builder, WorkloadConfiguration> {
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(WorkloadConfiguration::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(WorkloadConfiguration::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Configuration").getter(getter(WorkloadConfiguration::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_NAME_FIELD,
            TIER_FIELD, CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workloadName;

    private final String tier;

    private final String configuration;

    private WorkloadConfiguration(BuilderImpl builder) {
        this.workloadName = builder.workloadName;
        this.tier = builder.tier;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The name of the workload.
     * </p>
     * 
     * @return The name of the workload.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * <p>
     * The configuration of the workload tier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The configuration of the workload tier.
     * @see Tier
     */
    public final Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * <p>
     * The configuration of the workload tier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The configuration of the workload tier.
     * @see Tier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The configuration settings of the workload.
     * </p>
     * 
     * @return The configuration settings of the workload.
     */
    public final String configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadConfiguration)) {
            return false;
        }
        WorkloadConfiguration other = (WorkloadConfiguration) obj;
        return Objects.equals(workloadName(), other.workloadName()) && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkloadConfiguration").add("WorkloadName", workloadName()).add("Tier", tierAsString())
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkloadConfiguration, T> g) {
        return obj -> g.apply((WorkloadConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkloadConfiguration> {
        /**
         * <p>
         * The name of the workload.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * <p>
         * The configuration of the workload tier.
         * </p>
         * 
         * @param tier
         *        The configuration of the workload tier.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The configuration of the workload tier.
         * </p>
         * 
         * @param tier
         *        The configuration of the workload tier.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);

        /**
         * <p>
         * The configuration settings of the workload.
         * </p>
         * 
         * @param configuration
         *        The configuration settings of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(String configuration);
    }

    static final class BuilderImpl implements Builder {
        private String workloadName;

        private String tier;

        private String configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadConfiguration model) {
            workloadName(model.workloadName);
            tier(model.tier);
            configuration(model.configuration);
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getConfiguration() {
            return configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public WorkloadConfiguration build() {
            return new WorkloadConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
