/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsAsyncClient;
import software.amazon.awssdk.services.applicationinsights.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListConfigurationHistoryResponse;

public class ListConfigurationHistoryPublisher
implements SdkPublisher<ListConfigurationHistoryResponse> {
    private final ApplicationInsightsAsyncClient client;
    private final ListConfigurationHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationHistoryPublisher(ApplicationInsightsAsyncClient client, ListConfigurationHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationHistoryPublisher(ApplicationInsightsAsyncClient client, ListConfigurationHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListConfigurationHistoryResponseFetcher
    implements AsyncPageFetcher<ListConfigurationHistoryResponse> {
        private ListConfigurationHistoryResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationHistoryResponse> nextPage(ListConfigurationHistoryResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationHistoryPublisher.this.client.listConfigurationHistory(ListConfigurationHistoryPublisher.this.firstRequest);
            }
            return ListConfigurationHistoryPublisher.this.client.listConfigurationHistory((ListConfigurationHistoryRequest)((Object)ListConfigurationHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

