/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationItemType {
    SERVER("SERVER"),
    PROCESS("PROCESS"),
    CONNECTION("CONNECTION"),
    APPLICATION("APPLICATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationItemType> VALUE_MAP;
    private final String value;

    private ConfigurationItemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationItemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationItemType> knownValues() {
        EnumSet<ConfigurationItemType> knownValues = EnumSet.allOf(ConfigurationItemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationItemType.class, ConfigurationItemType::toString);
    }
}

