/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryClient;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse;

public class DescribeContinuousExportsIterable
implements SdkIterable<DescribeContinuousExportsResponse> {
    private final ApplicationDiscoveryClient client;
    private final DescribeContinuousExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeContinuousExportsIterable(ApplicationDiscoveryClient client, DescribeContinuousExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeContinuousExportsResponseFetcher();
    }

    public Iterator<DescribeContinuousExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeContinuousExportsResponseFetcher
    implements SyncPageFetcher<DescribeContinuousExportsResponse> {
        private DescribeContinuousExportsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeContinuousExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeContinuousExportsResponse nextPage(DescribeContinuousExportsResponse previousPage) {
            if (previousPage == null) {
                return DescribeContinuousExportsIterable.this.client.describeContinuousExports(DescribeContinuousExportsIterable.this.firstRequest);
            }
            return DescribeContinuousExportsIterable.this.client.describeContinuousExports((DescribeContinuousExportsRequest)((Object)DescribeContinuousExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

