/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationcostprofiler;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionRequest;
import software.amazon.awssdk.services.applicationcostprofiler.model.DeleteReportDefinitionResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionRequest;
import software.amazon.awssdk.services.applicationcostprofiler.model.GetReportDefinitionResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageRequest;
import software.amazon.awssdk.services.applicationcostprofiler.model.ImportApplicationUsageResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest;
import software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.PutReportDefinitionRequest;
import software.amazon.awssdk.services.applicationcostprofiler.model.PutReportDefinitionResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.UpdateReportDefinitionRequest;
import software.amazon.awssdk.services.applicationcostprofiler.model.UpdateReportDefinitionResponse;
import software.amazon.awssdk.services.applicationcostprofiler.paginators.ListReportDefinitionsPublisher;

/**
 * Service client for accessing AWS Application Cost Profiler asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * This reference provides descriptions of the AWS Application Cost Profiler API.
 * </p>
 * <p>
 * The AWS Application Cost Profiler API provides programmatic access to view, create, update, and delete application
 * cost report definitions, as well as to import your usage data into the Application Cost Profiler service.
 * </p>
 * <p>
 * For more information about using this service, see the <a
 * href="https://docs.aws.amazon.com/application-cost-profiler/latest/userguide/introduction.html">AWS Application Cost
 * Profiler User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ApplicationCostProfilerAsyncClient extends AwsClient {
    String SERVICE_NAME = "application-cost-profiler";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "application-cost-profiler";

    /**
     * <p>
     * Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being
     * generated.
     * </p>
     *
     * @param deleteReportDefinitionRequest
     * @return A Java Future containing the result of the DeleteReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.DeleteReportDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/DeleteReportDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReportDefinitionResponse> deleteReportDefinition(
            DeleteReportDefinitionRequest deleteReportDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified report definition in AWS Application Cost Profiler. This stops the report from being
     * generated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReportDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReportDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.DeleteReportDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/DeleteReportDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReportDefinitionResponse> deleteReportDefinition(
            Consumer<DeleteReportDefinitionRequest.Builder> deleteReportDefinitionRequest) {
        return deleteReportDefinition(DeleteReportDefinitionRequest.builder().applyMutation(deleteReportDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the definition of a report already configured in AWS Application Cost Profiler.
     * </p>
     *
     * @param getReportDefinitionRequest
     * @return A Java Future containing the result of the GetReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.GetReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/GetReportDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReportDefinitionResponse> getReportDefinition(
            GetReportDefinitionRequest getReportDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definition of a report already configured in AWS Application Cost Profiler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link GetReportDefinitionRequest#builder()}
     * </p>
     *
     * @param getReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetReportDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.GetReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/GetReportDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReportDefinitionResponse> getReportDefinition(
            Consumer<GetReportDefinitionRequest.Builder> getReportDefinitionRequest) {
        return getReportDefinition(GetReportDefinitionRequest.builder().applyMutation(getReportDefinitionRequest).build());
    }

    /**
     * <p>
     * Ingests application usage data from Amazon Simple Storage Service (Amazon S3).
     * </p>
     * <p>
     * The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler copies the
     * object from your S3 bucket to an S3 bucket owned by Amazon for processing asynchronously.
     * </p>
     *
     * @param importApplicationUsageRequest
     * @return A Java Future containing the result of the ImportApplicationUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.ImportApplicationUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ImportApplicationUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportApplicationUsageResponse> importApplicationUsage(
            ImportApplicationUsageRequest importApplicationUsageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Ingests application usage data from Amazon Simple Storage Service (Amazon S3).
     * </p>
     * <p>
     * The data must already exist in the S3 location. As part of the action, AWS Application Cost Profiler copies the
     * object from your S3 bucket to an S3 bucket owned by Amazon for processing asynchronously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportApplicationUsageRequest.Builder} avoiding the
     * need to create one manually via {@link ImportApplicationUsageRequest#builder()}
     * </p>
     *
     * @param importApplicationUsageRequest
     *        A {@link Consumer} that will call methods on {@link ImportApplicationUsageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportApplicationUsage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.ImportApplicationUsage
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ImportApplicationUsage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ImportApplicationUsageResponse> importApplicationUsage(
            Consumer<ImportApplicationUsageRequest.Builder> importApplicationUsageRequest) {
        return importApplicationUsage(ImportApplicationUsageRequest.builder().applyMutation(importApplicationUsageRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all reports and their configurations for your AWS account.
     * </p>
     * <p>
     * The maximum number of reports is one.
     * </p>
     *
     * @param listReportDefinitionsRequest
     * @return A Java Future containing the result of the ListReportDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.ListReportDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ListReportDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReportDefinitionsResponse> listReportDefinitions(
            ListReportDefinitionsRequest listReportDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all reports and their configurations for your AWS account.
     * </p>
     * <p>
     * The maximum number of reports is one.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReportDefinitionsRequest#builder()}
     * </p>
     *
     * @param listReportDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListReportDefinitionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReportDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.ListReportDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ListReportDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReportDefinitionsResponse> listReportDefinitions(
            Consumer<ListReportDefinitionsRequest.Builder> listReportDefinitionsRequest) {
        return listReportDefinitions(ListReportDefinitionsRequest.builder().applyMutation(listReportDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all reports and their configurations for your AWS account.
     * </p>
     * <p>
     * The maximum number of reports is one.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReportDefinitions(software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationcostprofiler.paginators.ListReportDefinitionsPublisher publisher = client.listReportDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationcostprofiler.paginators.ListReportDefinitionsPublisher publisher = client.listReportDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportDefinitions(software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReportDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.ListReportDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ListReportDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReportDefinitionsPublisher listReportDefinitionsPaginator(
            ListReportDefinitionsRequest listReportDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all reports and their configurations for your AWS account.
     * </p>
     * <p>
     * The maximum number of reports is one.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReportDefinitions(software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationcostprofiler.paginators.ListReportDefinitionsPublisher publisher = client.listReportDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.applicationcostprofiler.paginators.ListReportDefinitionsPublisher publisher = client.listReportDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReportDefinitions(software.amazon.awssdk.services.applicationcostprofiler.model.ListReportDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReportDefinitionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReportDefinitionsRequest#builder()}
     * </p>
     *
     * @param listReportDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListReportDefinitionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.ListReportDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/ListReportDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReportDefinitionsPublisher listReportDefinitionsPaginator(
            Consumer<ListReportDefinitionsRequest.Builder> listReportDefinitionsRequest) {
        return listReportDefinitionsPaginator(ListReportDefinitionsRequest.builder().applyMutation(listReportDefinitionsRequest)
                .build());
    }

    /**
     * <p>
     * Creates the report definition for a report in Application Cost Profiler.
     * </p>
     *
     * @param putReportDefinitionRequest
     * @return A Java Future containing the result of the PutReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds one or more of the service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.PutReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/PutReportDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutReportDefinitionResponse> putReportDefinition(
            PutReportDefinitionRequest putReportDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the report definition for a report in Application Cost Profiler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link PutReportDefinitionRequest#builder()}
     * </p>
     *
     * @param putReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link PutReportDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>ServiceQuotaExceededException Your request exceeds one or more of the service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.PutReportDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/PutReportDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutReportDefinitionResponse> putReportDefinition(
            Consumer<PutReportDefinitionRequest.Builder> putReportDefinitionRequest) {
        return putReportDefinition(PutReportDefinitionRequest.builder().applyMutation(putReportDefinitionRequest).build());
    }

    /**
     * <p>
     * Updates existing report in AWS Application Cost Profiler.
     * </p>
     *
     * @param updateReportDefinitionRequest
     * @return A Java Future containing the result of the UpdateReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.UpdateReportDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/UpdateReportDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReportDefinitionResponse> updateReportDefinition(
            UpdateReportDefinitionRequest updateReportDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates existing report in AWS Application Cost Profiler.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReportDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateReportDefinitionRequest#builder()}
     * </p>
     *
     * @param updateReportDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReportDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateReportDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ThrottlingException The calls to AWS Application Cost Profiler API are throttled. The request was
     *         denied.</li>
     *         <li>ValidationException The input fails to satisfy the constraints for the API.</li>
     *         <li>AccessDeniedException You do not have permission to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ApplicationCostProfilerException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ApplicationCostProfilerAsyncClient.UpdateReportDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWSApplicationCostProfiler-2020-09-10/UpdateReportDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReportDefinitionResponse> updateReportDefinition(
            Consumer<UpdateReportDefinitionRequest.Builder> updateReportDefinitionRequest) {
        return updateReportDefinition(UpdateReportDefinitionRequest.builder().applyMutation(updateReportDefinitionRequest)
                .build());
    }

    @Override
    default ApplicationCostProfilerServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ApplicationCostProfilerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ApplicationCostProfilerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ApplicationCostProfilerAsyncClient}.
     */
    static ApplicationCostProfilerAsyncClientBuilder builder() {
        return new DefaultApplicationCostProfilerAsyncClientBuilder();
    }
}
