/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.appintegrations.model.AccessDeniedException;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsException;
import software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest;
import software.amazon.awssdk.services.appintegrations.model.CreateApplicationResponse;
import software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.DuplicateResourceException;
import software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest;
import software.amazon.awssdk.services.appintegrations.model.GetApplicationResponse;
import software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.InternalServiceErrorException;
import software.amazon.awssdk.services.appintegrations.model.InvalidRequestException;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appintegrations.model.ResourceQuotaExceededException;
import software.amazon.awssdk.services.appintegrations.model.TagResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.TagResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.ThrottlingException;
import software.amazon.awssdk.services.appintegrations.model.UntagResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.UntagResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.appintegrations.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsIterable;
import software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsIterable;
import software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsIterable;
import software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsIterable;

/**
 * Service client for accessing Amazon AppIntegrations Service. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The Amazon AppIntegrations service enables you to configure and reuse connections to external applications.
 * </p>
 * <p>
 * For information about how you can use external applications with Amazon Connect, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/crm.html">Set up pre-built integrations</a> and <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-wisdom.html">Deliver information to agents
 * using Amazon Connect Wisdom</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppIntegrationsClient extends AwsClient {
    String SERVICE_NAME = "app-integrations";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "app-integrations";

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Creates and persists an Application resource.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceQuotaExceededException
     *         The allowed quota for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws InternalServiceErrorException, ResourceQuotaExceededException, DuplicateResourceException,
            ThrottlingException, InvalidRequestException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Creates and persists an Application resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceQuotaExceededException
     *         The allowed quota for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws InternalServiceErrorException, ResourceQuotaExceededException, DuplicateResourceException,
            ThrottlingException, InvalidRequestException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppIntegrationsException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates and persists a DataIntegration resource.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <code>CreateDataIntegration</code> API.
     * </p>
     * </note>
     *
     * @param createDataIntegrationRequest
     * @return Result of the CreateDataIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceQuotaExceededException
     *         The allowed quota for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.CreateDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataIntegrationResponse createDataIntegration(CreateDataIntegrationRequest createDataIntegrationRequest)
            throws InternalServiceErrorException, ResourceQuotaExceededException, DuplicateResourceException,
            ThrottlingException, InvalidRequestException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and persists a DataIntegration resource.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <code>CreateDataIntegration</code> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataIntegrationRequest#builder()}
     * </p>
     *
     * @param createDataIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateDataIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceQuotaExceededException
     *         The allowed quota for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.CreateDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDataIntegrationResponse createDataIntegration(
            Consumer<CreateDataIntegrationRequest.Builder> createDataIntegrationRequest) throws InternalServiceErrorException,
            ResourceQuotaExceededException, DuplicateResourceException, ThrottlingException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return createDataIntegration(CreateDataIntegrationRequest.builder().applyMutation(createDataIntegrationRequest).build());
    }

    /**
     * <p>
     * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in
     * your account and a partner event source that pushes events to that bus. No objects are created in the your
     * account, only metadata that is persisted on the EventIntegration control plane.
     * </p>
     *
     * @param createEventIntegrationRequest
     * @return Result of the CreateEventIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceQuotaExceededException
     *         The allowed quota for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.CreateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventIntegrationResponse createEventIntegration(CreateEventIntegrationRequest createEventIntegrationRequest)
            throws InternalServiceErrorException, ResourceQuotaExceededException, DuplicateResourceException,
            ThrottlingException, InvalidRequestException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in
     * your account and a partner event source that pushes events to that bus. No objects are created in the your
     * account, only metadata that is persisted on the EventIntegration control plane.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventIntegrationRequest#builder()}
     * </p>
     *
     * @param createEventIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateEventIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceQuotaExceededException
     *         The allowed quota for the resource has been exceeded.
     * @throws DuplicateResourceException
     *         A resource with the specified name already exists.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.CreateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventIntegrationResponse createEventIntegration(
            Consumer<CreateEventIntegrationRequest.Builder> createEventIntegrationRequest) throws InternalServiceErrorException,
            ResourceQuotaExceededException, DuplicateResourceException, ThrottlingException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return createEventIntegration(CreateEventIntegrationRequest.builder().applyMutation(createEventIntegrationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be
     * deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param deleteDataIntegrationRequest
     * @return Result of the DeleteDataIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.DeleteDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataIntegrationResponse deleteDataIntegration(DeleteDataIntegrationRequest deleteDataIntegrationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be
     * deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteDataIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteDataIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.DeleteDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDataIntegrationResponse deleteDataIntegration(
            Consumer<DeleteDataIntegrationRequest.Builder> deleteDataIntegrationRequest) throws InternalServiceErrorException,
            ThrottlingException, ResourceNotFoundException, InvalidRequestException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        return deleteDataIntegration(DeleteDataIntegrationRequest.builder().applyMutation(deleteDataIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified existing event integration. If the event integration is associated with clients, the
     * request is rejected.
     * </p>
     *
     * @param deleteEventIntegrationRequest
     * @return Result of the DeleteEventIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.DeleteEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventIntegrationResponse deleteEventIntegration(DeleteEventIntegrationRequest deleteEventIntegrationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified existing event integration. If the event integration is associated with clients, the
     * request is rejected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteEventIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteEventIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.DeleteEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventIntegrationResponse deleteEventIntegration(
            Consumer<DeleteEventIntegrationRequest.Builder> deleteEventIntegrationRequest) throws InternalServiceErrorException,
            ThrottlingException, ResourceNotFoundException, InvalidRequestException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        return deleteEventIntegration(DeleteEventIntegrationRequest.builder().applyMutation(deleteEventIntegrationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Get an Application resource.
     * </p>
     *
     * @param getApplicationRequest
     * @return Result of the GetApplication operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Get an Application resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the GetApplication operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationResponse getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Returns information about the DataIntegration.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param getDataIntegrationRequest
     * @return Result of the GetDataIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.GetDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationResponse getDataIntegration(GetDataIntegrationRequest getDataIntegrationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the DataIntegration.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataIntegrationRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest.Builder} to create
     *        a request.
     * @return Result of the GetDataIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.GetDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataIntegrationResponse getDataIntegration(Consumer<GetDataIntegrationRequest.Builder> getDataIntegrationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return getDataIntegration(GetDataIntegrationRequest.builder().applyMutation(getDataIntegrationRequest).build());
    }

    /**
     * <p>
     * Returns information about the event integration.
     * </p>
     *
     * @param getEventIntegrationRequest
     * @return Result of the GetEventIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.GetEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventIntegrationResponse getEventIntegration(GetEventIntegrationRequest getEventIntegrationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the event integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventIntegrationRequest#builder()}
     * </p>
     *
     * @param getEventIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest.Builder} to create
     *        a request.
     * @return Result of the GetEventIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.GetEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventIntegrationResponse getEventIntegration(
            Consumer<GetEventIntegrationRequest.Builder> getEventIntegrationRequest) throws InternalServiceErrorException,
            ThrottlingException, ResourceNotFoundException, InvalidRequestException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        return getEventIntegration(GetEventIntegrationRequest.builder().applyMutation(getEventIntegrationRequest).build());
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Lists applications in the account.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws InternalServiceErrorException, ThrottlingException, InvalidRequestException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Lists applications in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListApplications operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws InternalServiceErrorException, ThrottlingException, InvalidRequestException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Lists applications in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws InternalServiceErrorException, ThrottlingException, InvalidRequestException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Lists applications in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws InternalServiceErrorException, ThrottlingException, InvalidRequestException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegration associations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param listDataIntegrationAssociationsRequest
     * @return Result of the ListDataIntegrationAssociations operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListDataIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationAssociationsResponse listDataIntegrationAssociations(
            ListDataIntegrationAssociationsRequest listDataIntegrationAssociationsRequest) throws InternalServiceErrorException,
            ThrottlingException, ResourceNotFoundException, InvalidRequestException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegration associations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListDataIntegrationAssociations operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListDataIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationAssociationsResponse listDataIntegrationAssociations(
            Consumer<ListDataIntegrationAssociationsRequest.Builder> listDataIntegrationAssociationsRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return listDataIntegrationAssociations(ListDataIntegrationAssociationsRequest.builder()
                .applyMutation(listDataIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegration associations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsIterable responses = client.listDataIntegrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsIterable responses = client
     *             .listDataIntegrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsIterable responses = client.listDataIntegrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListDataIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationAssociationsIterable listDataIntegrationAssociationsPaginator(
            ListDataIntegrationAssociationsRequest listDataIntegrationAssociationsRequest) throws InternalServiceErrorException,
            ThrottlingException, ResourceNotFoundException, InvalidRequestException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        return new ListDataIntegrationAssociationsIterable(this, listDataIntegrationAssociationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegration associations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsIterable responses = client.listDataIntegrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsIterable responses = client
     *             .listDataIntegrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsIterable responses = client.listDataIntegrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListDataIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationAssociationsIterable listDataIntegrationAssociationsPaginator(
            Consumer<ListDataIntegrationAssociationsRequest.Builder> listDataIntegrationAssociationsRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return listDataIntegrationAssociationsPaginator(ListDataIntegrationAssociationsRequest.builder()
                .applyMutation(listDataIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegrations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param listDataIntegrationsRequest
     * @return Result of the ListDataIntegrations operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListDataIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationsResponse listDataIntegrations(ListDataIntegrationsRequest listDataIntegrationsRequest)
            throws InternalServiceErrorException, ThrottlingException, InvalidRequestException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegrations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataIntegrationsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDataIntegrations operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListDataIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationsResponse listDataIntegrations(
            Consumer<ListDataIntegrationsRequest.Builder> listDataIntegrationsRequest) throws InternalServiceErrorException,
            ThrottlingException, InvalidRequestException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppIntegrationsException {
        return listDataIntegrations(ListDataIntegrationsRequest.builder().applyMutation(listDataIntegrationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegrations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDataIntegrations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsIterable responses = client.listDataIntegrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsIterable responses = client
     *             .listDataIntegrationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsIterable responses = client.listDataIntegrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListDataIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationsIterable listDataIntegrationsPaginator(ListDataIntegrationsRequest listDataIntegrationsRequest)
            throws InternalServiceErrorException, ThrottlingException, InvalidRequestException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        return new ListDataIntegrationsIterable(this, listDataIntegrationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegrations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDataIntegrations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsIterable responses = client.listDataIntegrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsIterable responses = client
     *             .listDataIntegrationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsIterable responses = client.listDataIntegrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataIntegrationsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListDataIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationsIterable listDataIntegrationsPaginator(
            Consumer<ListDataIntegrationsRequest.Builder> listDataIntegrationsRequest) throws InternalServiceErrorException,
            ThrottlingException, InvalidRequestException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppIntegrationsException {
        return listDataIntegrationsPaginator(ListDataIntegrationsRequest.builder().applyMutation(listDataIntegrationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     * @return Result of the ListEventIntegrationAssociations operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationAssociationsResponse listEventIntegrationAssociations(
            ListEventIntegrationAssociationsRequest listEventIntegrationAssociationsRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListEventIntegrationAssociations operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationAssociationsResponse listEventIntegrationAssociations(
            Consumer<ListEventIntegrationAssociationsRequest.Builder> listEventIntegrationAssociationsRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return listEventIntegrationAssociations(ListEventIntegrationAssociationsRequest.builder()
                .applyMutation(listEventIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsIterable responses = client.listEventIntegrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsIterable responses = client
     *             .listEventIntegrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsIterable responses = client.listEventIntegrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationAssociationsIterable listEventIntegrationAssociationsPaginator(
            ListEventIntegrationAssociationsRequest listEventIntegrationAssociationsRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return new ListEventIntegrationAssociationsIterable(this, listEventIntegrationAssociationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsIterable responses = client.listEventIntegrationAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsIterable responses = client
     *             .listEventIntegrationAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsIterable responses = client.listEventIntegrationAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationAssociationsIterable listEventIntegrationAssociationsPaginator(
            Consumer<ListEventIntegrationAssociationsRequest.Builder> listEventIntegrationAssociationsRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return listEventIntegrationAssociationsPaginator(ListEventIntegrationAssociationsRequest.builder()
                .applyMutation(listEventIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     *
     * @param listEventIntegrationsRequest
     * @return Result of the ListEventIntegrations operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationsResponse listEventIntegrations(ListEventIntegrationsRequest listEventIntegrationsRequest)
            throws InternalServiceErrorException, ThrottlingException, InvalidRequestException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventIntegrationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListEventIntegrations operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationsResponse listEventIntegrations(
            Consumer<ListEventIntegrationsRequest.Builder> listEventIntegrationsRequest) throws InternalServiceErrorException,
            ThrottlingException, InvalidRequestException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppIntegrationsException {
        return listEventIntegrations(ListEventIntegrationsRequest.builder().applyMutation(listEventIntegrationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventIntegrations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsIterable responses = client.listEventIntegrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsIterable responses = client
     *             .listEventIntegrationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsIterable responses = client.listEventIntegrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventIntegrations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventIntegrationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationsIterable listEventIntegrationsPaginator(ListEventIntegrationsRequest listEventIntegrationsRequest)
            throws InternalServiceErrorException, ThrottlingException, InvalidRequestException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        return new ListEventIntegrationsIterable(this, listEventIntegrationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventIntegrations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsIterable responses = client.listEventIntegrationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsIterable responses = client
     *             .listEventIntegrationsPaginator(request);
     *     for (software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsIterable responses = client.listEventIntegrationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventIntegrations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventIntegrationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationsIterable listEventIntegrationsPaginator(
            Consumer<ListEventIntegrationsRequest.Builder> listEventIntegrationsRequest) throws InternalServiceErrorException,
            ThrottlingException, InvalidRequestException, AccessDeniedException, AwsServiceException, SdkClientException,
            AppIntegrationsException {
        return listEventIntegrationsPaginator(ListEventIntegrationsRequest.builder().applyMutation(listEventIntegrationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            InternalServiceErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            InternalServiceErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            InternalServiceErrorException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidRequestException, InternalServiceErrorException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, AppIntegrationsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Updates and persists an Application resource.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Updates and persists an Application resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the description of a DataIntegration.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param updateDataIntegrationRequest
     * @return Result of the UpdateDataIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.UpdateDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataIntegrationResponse updateDataIntegration(UpdateDataIntegrationRequest updateDataIntegrationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of a DataIntegration.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDataIntegrationRequest#builder()}
     * </p>
     *
     * @param updateDataIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateDataIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.UpdateDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDataIntegrationResponse updateDataIntegration(
            Consumer<UpdateDataIntegrationRequest.Builder> updateDataIntegrationRequest) throws InternalServiceErrorException,
            ThrottlingException, ResourceNotFoundException, InvalidRequestException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        return updateDataIntegration(UpdateDataIntegrationRequest.builder().applyMutation(updateDataIntegrationRequest).build());
    }

    /**
     * <p>
     * Updates the description of an event integration.
     * </p>
     *
     * @param updateEventIntegrationRequest
     * @return Result of the UpdateEventIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.UpdateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventIntegrationResponse updateEventIntegration(UpdateEventIntegrationRequest updateEventIntegrationRequest)
            throws InternalServiceErrorException, ThrottlingException, ResourceNotFoundException, InvalidRequestException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppIntegrationsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of an event integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEventIntegrationRequest#builder()}
     * </p>
     *
     * @param updateEventIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateEventIntegration operation returned by the service.
     * @throws InternalServiceErrorException
     *         Request processing failed due to an error or failure with the service.
     * @throws ThrottlingException
     *         The throttling limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppIntegrationsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppIntegrationsClient.UpdateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventIntegrationResponse updateEventIntegration(
            Consumer<UpdateEventIntegrationRequest.Builder> updateEventIntegrationRequest) throws InternalServiceErrorException,
            ThrottlingException, ResourceNotFoundException, InvalidRequestException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppIntegrationsException {
        return updateEventIntegration(UpdateEventIntegrationRequest.builder().applyMutation(updateEventIntegrationRequest)
                .build());
    }

    /**
     * Create a {@link AppIntegrationsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppIntegrationsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppIntegrationsClient}.
     */
    static AppIntegrationsClientBuilder builder() {
        return new DefaultAppIntegrationsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default AppIntegrationsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
