/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest;
import software.amazon.awssdk.services.appintegrations.model.CreateApplicationResponse;
import software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest;
import software.amazon.awssdk.services.appintegrations.model.GetApplicationResponse;
import software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.TagResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.TagResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.UntagResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.UntagResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.appintegrations.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsPublisher;
import software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsPublisher;
import software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsPublisher;
import software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsPublisher;

/**
 * Service client for accessing Amazon AppIntegrations Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The Amazon AppIntegrations service enables you to configure and reuse connections to external applications.
 * </p>
 * <p>
 * For information about how you can use external applications with Amazon Connect, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/crm.html">Set up pre-built integrations</a> and <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-wisdom.html">Deliver information to agents
 * using Amazon Connect Wisdom</a> in the <i>Amazon Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppIntegrationsAsyncClient extends AwsClient {
    String SERVICE_NAME = "app-integrations";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "app-integrations";

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Creates and persists an Application resource.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceQuotaExceededException The allowed quota for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Creates and persists an Application resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceQuotaExceededException The allowed quota for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates and persists a DataIntegration resource.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <code>CreateDataIntegration</code> API.
     * </p>
     * </note>
     *
     * @param createDataIntegrationRequest
     * @return A Java Future containing the result of the CreateDataIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceQuotaExceededException The allowed quota for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.CreateDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataIntegrationResponse> createDataIntegration(
            CreateDataIntegrationRequest createDataIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and persists a DataIntegration resource.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <code>CreateDataIntegration</code> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataIntegrationRequest#builder()}
     * </p>
     *
     * @param createDataIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDataIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceQuotaExceededException The allowed quota for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.CreateDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataIntegrationResponse> createDataIntegration(
            Consumer<CreateDataIntegrationRequest.Builder> createDataIntegrationRequest) {
        return createDataIntegration(CreateDataIntegrationRequest.builder().applyMutation(createDataIntegrationRequest).build());
    }

    /**
     * <p>
     * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in
     * your account and a partner event source that pushes events to that bus. No objects are created in the your
     * account, only metadata that is persisted on the EventIntegration control plane.
     * </p>
     *
     * @param createEventIntegrationRequest
     * @return A Java Future containing the result of the CreateEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceQuotaExceededException The allowed quota for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.CreateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventIntegrationResponse> createEventIntegration(
            CreateEventIntegrationRequest createEventIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon EventBridge bus in
     * your account and a partner event source that pushes events to that bus. No objects are created in the your
     * account, only metadata that is persisted on the EventIntegration control plane.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventIntegrationRequest#builder()}
     * </p>
     *
     * @param createEventIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceQuotaExceededException The allowed quota for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.CreateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventIntegrationResponse> createEventIntegration(
            Consumer<CreateEventIntegrationRequest.Builder> createEventIntegrationRequest) {
        return createEventIntegration(CreateEventIntegrationRequest.builder().applyMutation(createEventIntegrationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be
     * deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param deleteDataIntegrationRequest
     * @return A Java Future containing the result of the DeleteDataIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.DeleteDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataIntegrationResponse> deleteDataIntegration(
            DeleteDataIntegrationRequest deleteDataIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations can be
     * deleted. Deleting a DataIntegration also deletes the underlying Amazon AppFlow flow and service linked role.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteDataIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDataIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.DeleteDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataIntegrationResponse> deleteDataIntegration(
            Consumer<DeleteDataIntegrationRequest.Builder> deleteDataIntegrationRequest) {
        return deleteDataIntegration(DeleteDataIntegrationRequest.builder().applyMutation(deleteDataIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified existing event integration. If the event integration is associated with clients, the
     * request is rejected.
     * </p>
     *
     * @param deleteEventIntegrationRequest
     * @return A Java Future containing the result of the DeleteEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.DeleteEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventIntegrationResponse> deleteEventIntegration(
            DeleteEventIntegrationRequest deleteEventIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified existing event integration. If the event integration is associated with clients, the
     * request is rejected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteEventIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.DeleteEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventIntegrationResponse> deleteEventIntegration(
            Consumer<DeleteEventIntegrationRequest.Builder> deleteEventIntegrationRequest) {
        return deleteEventIntegration(DeleteEventIntegrationRequest.builder().applyMutation(deleteEventIntegrationRequest)
                .build());
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Get an Application resource.
     * </p>
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Get an Application resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Returns information about the DataIntegration.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param getDataIntegrationRequest
     * @return A Java Future containing the result of the GetDataIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.GetDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataIntegrationResponse> getDataIntegration(GetDataIntegrationRequest getDataIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the DataIntegration.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link GetDataIntegrationRequest#builder()}
     * </p>
     *
     * @param getDataIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetDataIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.GetDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDataIntegrationResponse> getDataIntegration(
            Consumer<GetDataIntegrationRequest.Builder> getDataIntegrationRequest) {
        return getDataIntegration(GetDataIntegrationRequest.builder().applyMutation(getDataIntegrationRequest).build());
    }

    /**
     * <p>
     * Returns information about the event integration.
     * </p>
     *
     * @param getEventIntegrationRequest
     * @return A Java Future containing the result of the GetEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.GetEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventIntegrationResponse> getEventIntegration(
            GetEventIntegrationRequest getEventIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the event integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventIntegrationRequest#builder()}
     * </p>
     *
     * @param getEventIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.GetEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventIntegrationResponse> getEventIntegration(
            Consumer<GetEventIntegrationRequest.Builder> getEventIntegrationRequest) {
        return getEventIntegration(GetEventIntegrationRequest.builder().applyMutation(getEventIntegrationRequest).build());
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Lists applications in the account.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Lists applications in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Lists applications in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        return new ListApplicationsPublisher(this, listApplicationsRequest);
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Lists applications in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegration associations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param listDataIntegrationAssociationsRequest
     * @return A Java Future containing the result of the ListDataIntegrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListDataIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationAssociationsResponse> listDataIntegrationAssociations(
            ListDataIntegrationAssociationsRequest listDataIntegrationAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegration associations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListDataIntegrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListDataIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationAssociationsResponse> listDataIntegrationAssociations(
            Consumer<ListDataIntegrationAssociationsRequest.Builder> listDataIntegrationAssociationsRequest) {
        return listDataIntegrationAssociations(ListDataIntegrationAssociationsRequest.builder()
                .applyMutation(listDataIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegration associations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsPublisher publisher = client.listDataIntegrationAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsPublisher publisher = client.listDataIntegrationAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListDataIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationAssociationsPublisher listDataIntegrationAssociationsPaginator(
            ListDataIntegrationAssociationsRequest listDataIntegrationAssociationsRequest) {
        return new ListDataIntegrationAssociationsPublisher(this, listDataIntegrationAssociationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegration associations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDataIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsPublisher publisher = client.listDataIntegrationAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationAssociationsPublisher publisher = client.listDataIntegrationAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDataIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListDataIntegrationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationAssociationsPublisher listDataIntegrationAssociationsPaginator(
            Consumer<ListDataIntegrationAssociationsRequest.Builder> listDataIntegrationAssociationsRequest) {
        return listDataIntegrationAssociationsPaginator(ListDataIntegrationAssociationsRequest.builder()
                .applyMutation(listDataIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegrations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param listDataIntegrationsRequest
     * @return A Java Future containing the result of the ListDataIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListDataIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationsResponse> listDataIntegrations(
            ListDataIntegrationsRequest listDataIntegrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegrations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataIntegrationsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListDataIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListDataIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDataIntegrationsResponse> listDataIntegrations(
            Consumer<ListDataIntegrationsRequest.Builder> listDataIntegrationsRequest) {
        return listDataIntegrations(ListDataIntegrationsRequest.builder().applyMutation(listDataIntegrationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegrations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDataIntegrations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsPublisher publisher = client.listDataIntegrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsPublisher publisher = client.listDataIntegrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDataIntegrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListDataIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationsPublisher listDataIntegrationsPaginator(ListDataIntegrationsRequest listDataIntegrationsRequest) {
        return new ListDataIntegrationsPublisher(this, listDataIntegrationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of DataIntegrations in the account.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listDataIntegrations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsPublisher publisher = client.listDataIntegrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListDataIntegrationsPublisher publisher = client.listDataIntegrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataIntegrations(software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDataIntegrationsRequest#builder()}
     * </p>
     *
     * @param listDataIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListDataIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDataIntegrationsPublisher listDataIntegrationsPaginator(
            Consumer<ListDataIntegrationsRequest.Builder> listDataIntegrationsRequest) {
        return listDataIntegrationsPaginator(ListDataIntegrationsRequest.builder().applyMutation(listDataIntegrationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     * @return A Java Future containing the result of the ListEventIntegrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventIntegrationAssociationsResponse> listEventIntegrationAssociations(
            ListEventIntegrationAssociationsRequest listEventIntegrationAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListEventIntegrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventIntegrationAssociationsResponse> listEventIntegrationAssociations(
            Consumer<ListEventIntegrationAssociationsRequest.Builder> listEventIntegrationAssociationsRequest) {
        return listEventIntegrationAssociations(ListEventIntegrationAssociationsRequest.builder()
                .applyMutation(listEventIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsPublisher publisher = client.listEventIntegrationAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsPublisher publisher = client.listEventIntegrationAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationAssociationsPublisher listEventIntegrationAssociationsPaginator(
            ListEventIntegrationAssociationsRequest listEventIntegrationAssociationsRequest) {
        return new ListEventIntegrationAssociationsPublisher(this, listEventIntegrationAssociationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsPublisher publisher = client.listEventIntegrationAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationAssociationsPublisher publisher = client.listEventIntegrationAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventIntegrationAssociations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationAssociationsPublisher listEventIntegrationAssociationsPaginator(
            Consumer<ListEventIntegrationAssociationsRequest.Builder> listEventIntegrationAssociationsRequest) {
        return listEventIntegrationAssociationsPaginator(ListEventIntegrationAssociationsRequest.builder()
                .applyMutation(listEventIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     *
     * @param listEventIntegrationsRequest
     * @return A Java Future containing the result of the ListEventIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventIntegrationsResponse> listEventIntegrations(
            ListEventIntegrationsRequest listEventIntegrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventIntegrationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEventIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventIntegrationsResponse> listEventIntegrations(
            Consumer<ListEventIntegrationsRequest.Builder> listEventIntegrationsRequest) {
        return listEventIntegrations(ListEventIntegrationsRequest.builder().applyMutation(listEventIntegrationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventIntegrations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsPublisher publisher = client.listEventIntegrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsPublisher publisher = client.listEventIntegrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventIntegrations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventIntegrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationsPublisher listEventIntegrationsPaginator(
            ListEventIntegrationsRequest listEventIntegrationsRequest) {
        return new ListEventIntegrationsPublisher(this, listEventIntegrationsRequest);
    }

    /**
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventIntegrations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsPublisher publisher = client.listEventIntegrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appintegrations.paginators.ListEventIntegrationsPublisher publisher = client.listEventIntegrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventIntegrations(software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventIntegrationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventIntegrationsPublisher listEventIntegrationsPaginator(
            Consumer<ListEventIntegrationsRequest.Builder> listEventIntegrationsRequest) {
        return listEventIntegrationsPaginator(ListEventIntegrationsRequest.builder().applyMutation(listEventIntegrationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Updates and persists an Application resource.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This API is in preview release and subject to change.
     * </p>
     * <p>
     * Updates and persists an Application resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the description of a DataIntegration.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note>
     *
     * @param updateDataIntegrationRequest
     * @return A Java Future containing the result of the UpdateDataIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UpdateDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataIntegrationResponse> updateDataIntegration(
            UpdateDataIntegrationRequest updateDataIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of a DataIntegration.
     * </p>
     * <note>
     * <p>
     * You cannot create a DataIntegration association for a DataIntegration that has been previously associated. Use a
     * different DataIntegration, or recreate the DataIntegration using the <a
     * href="https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html"
     * >CreateDataIntegration</a> API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDataIntegrationRequest#builder()}
     * </p>
     *
     * @param updateDataIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDataIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UpdateDataIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateDataIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDataIntegrationResponse> updateDataIntegration(
            Consumer<UpdateDataIntegrationRequest.Builder> updateDataIntegrationRequest) {
        return updateDataIntegration(UpdateDataIntegrationRequest.builder().applyMutation(updateDataIntegrationRequest).build());
    }

    /**
     * <p>
     * Updates the description of an event integration.
     * </p>
     *
     * @param updateEventIntegrationRequest
     * @return A Java Future containing the result of the UpdateEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UpdateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventIntegrationResponse> updateEventIntegration(
            UpdateEventIntegrationRequest updateEventIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of an event integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEventIntegrationRequest#builder()}
     * </p>
     *
     * @param updateEventIntegrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UpdateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventIntegrationResponse> updateEventIntegration(
            Consumer<UpdateEventIntegrationRequest.Builder> updateEventIntegrationRequest) {
        return updateEventIntegration(UpdateEventIntegrationRequest.builder().applyMutation(updateEventIntegrationRequest)
                .build());
    }

    @Override
    default AppIntegrationsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AppIntegrationsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppIntegrationsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppIntegrationsAsyncClient}.
     */
    static AppIntegrationsAsyncClientBuilder builder() {
        return new DefaultAppIntegrationsAsyncClientBuilder();
    }
}
