/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.appflow.AppflowClient;
import software.amazon.awssdk.services.appflow.AppflowClientBuilder;
import software.amazon.awssdk.services.appflow.AppflowServiceClientConfiguration;
import software.amazon.awssdk.services.appflow.DefaultAppflowBaseClientBuilder;
import software.amazon.awssdk.services.appflow.DefaultAppflowClient;
import software.amazon.awssdk.services.appflow.endpoints.AppflowEndpointProvider;

@SdkInternalApi
final class DefaultAppflowClientBuilder
extends DefaultAppflowBaseClientBuilder<AppflowClientBuilder, AppflowClient>
implements AppflowClientBuilder {
    DefaultAppflowClientBuilder() {
    }

    @Override
    public DefaultAppflowClientBuilder endpointProvider(AppflowEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AppflowClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAppflowClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AppflowServiceClientConfiguration serviceClientConfiguration = AppflowServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAppflowClient(serviceClientConfiguration, clientConfiguration);
    }
}

