/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WriteOperationType {
    INSERT("INSERT"),
    UPSERT("UPSERT"),
    UPDATE("UPDATE"),
    DELETE("DELETE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WriteOperationType> VALUE_MAP;
    private final String value;

    private WriteOperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WriteOperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WriteOperationType> knownValues() {
        EnumSet<WriteOperationType> knownValues = EnumSet.allOf(WriteOperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WriteOperationType.class, WriteOperationType::toString);
    }
}

