/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfigdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfigdata.model.InvalidParameterDetail;
import software.amazon.awssdk.services.appconfigdata.model.InvalidParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BadRequestDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BadRequestDetails> {
    private static final SdkField<Map<String, InvalidParameterDetail>> INVALID_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("InvalidParameters").getter(BadRequestDetails.getter(BadRequestDetails::invalidParameters)).setter(BadRequestDetails.setter(Builder::invalidParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvalidParameterDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, InvalidParameterDetail> invalidParameters;
    private final Type type;

    private BadRequestDetails(BuilderImpl builder) {
        this.invalidParameters = builder.invalidParameters;
        this.type = builder.type;
    }

    public final boolean hasInvalidParameters() {
        return this.invalidParameters != null && !(this.invalidParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, InvalidParameterDetail> invalidParameters() {
        return this.invalidParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvalidParameters() ? this.invalidParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BadRequestDetails)) {
            return false;
        }
        BadRequestDetails other = (BadRequestDetails)obj;
        return this.hasInvalidParameters() == other.hasInvalidParameters() && Objects.equals(this.invalidParameters(), other.invalidParameters());
    }

    public final String toString() {
        return ToString.builder((String)"BadRequestDetails").add("InvalidParameters", this.hasInvalidParameters() ? this.invalidParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvalidParameters": {
                return Optional.ofNullable(clazz.cast(this.invalidParameters()));
            }
        }
        return Optional.empty();
    }

    public static BadRequestDetails fromInvalidParameters(Map<String, InvalidParameterDetail> invalidParameters) {
        return (BadRequestDetails)BadRequestDetails.builder().invalidParameters(invalidParameters).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BadRequestDetails, T> g) {
        return obj -> g.apply((BadRequestDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INVALID_PARAMETERS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, InvalidParameterDetail> invalidParameters = DefaultSdkAutoConstructMap.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(BadRequestDetails model) {
            this.invalidParameters(model.invalidParameters);
        }

        public final Map<String, InvalidParameterDetail.Builder> getInvalidParameters() {
            Map<String, InvalidParameterDetail.Builder> result = InvalidParameterMapCopier.copyToBuilder(this.invalidParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInvalidParameters(Map<String, InvalidParameterDetail.BuilderImpl> invalidParameters) {
            Map<String, InvalidParameterDetail> oldValue = this.invalidParameters;
            this.invalidParameters = InvalidParameterMapCopier.copyFromBuilder(invalidParameters);
            this.handleUnionValueChange(Type.INVALID_PARAMETERS, oldValue, this.invalidParameters);
        }

        @Override
        public final Builder invalidParameters(Map<String, InvalidParameterDetail> invalidParameters) {
            Map<String, InvalidParameterDetail> oldValue = this.invalidParameters;
            this.invalidParameters = InvalidParameterMapCopier.copy(invalidParameters);
            this.handleUnionValueChange(Type.INVALID_PARAMETERS, oldValue, this.invalidParameters);
            return this;
        }

        public BadRequestDetails build() {
            return new BadRequestDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BadRequestDetails> {
        public Builder invalidParameters(Map<String, InvalidParameterDetail> var1);
    }
}

