/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExtensionAssociationsRequest extends AppConfigRequest implements
        ToCopyableBuilder<ListExtensionAssociationsRequest.Builder, ListExtensionAssociationsRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(ListExtensionAssociationsRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resource_identifier").build())
            .build();

    private static final SdkField<String> EXTENSION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtensionIdentifier").getter(getter(ListExtensionAssociationsRequest::extensionIdentifier))
            .setter(setter(Builder::extensionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("extension_identifier").build())
            .build();

    private static final SdkField<Integer> EXTENSION_VERSION_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExtensionVersionNumber")
            .getter(getter(ListExtensionAssociationsRequest::extensionVersionNumber))
            .setter(setter(Builder::extensionVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("extension_version_number")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListExtensionAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max_results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListExtensionAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next_token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD,
            EXTENSION_IDENTIFIER_FIELD, EXTENSION_VERSION_NUMBER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String resourceIdentifier;

    private final String extensionIdentifier;

    private final Integer extensionVersionNumber;

    private final Integer maxResults;

    private final String nextToken;

    private ListExtensionAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.extensionIdentifier = builder.extensionIdentifier;
        this.extensionVersionNumber = builder.extensionVersionNumber;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ARN of an application, configuration profile, or environment.
     * </p>
     * 
     * @return The ARN of an application, configuration profile, or environment.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The name, the ID, or the Amazon Resource Name (ARN) of the extension.
     * </p>
     * 
     * @return The name, the ID, or the Amazon Resource Name (ARN) of the extension.
     */
    public final String extensionIdentifier() {
        return extensionIdentifier;
    }

    /**
     * <p>
     * The version number for the extension defined in the association.
     * </p>
     * 
     * @return The version number for the extension defined in the association.
     */
    public final Integer extensionVersionNumber() {
        return extensionVersionNumber;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to start the list. Use this token to get the next set of results or pass null to get the first set of
     * results.
     * </p>
     * 
     * @return A token to start the list. Use this token to get the next set of results or pass null to get the first
     *         set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(extensionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(extensionVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExtensionAssociationsRequest)) {
            return false;
        }
        ListExtensionAssociationsRequest other = (ListExtensionAssociationsRequest) obj;
        return Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(extensionIdentifier(), other.extensionIdentifier())
                && Objects.equals(extensionVersionNumber(), other.extensionVersionNumber())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExtensionAssociationsRequest").add("ResourceIdentifier", resourceIdentifier())
                .add("ExtensionIdentifier", extensionIdentifier()).add("ExtensionVersionNumber", extensionVersionNumber())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ExtensionIdentifier":
            return Optional.ofNullable(clazz.cast(extensionIdentifier()));
        case "ExtensionVersionNumber":
            return Optional.ofNullable(clazz.cast(extensionVersionNumber()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExtensionAssociationsRequest, T> g) {
        return obj -> g.apply((ListExtensionAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListExtensionAssociationsRequest> {
        /**
         * <p>
         * The ARN of an application, configuration profile, or environment.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ARN of an application, configuration profile, or environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The name, the ID, or the Amazon Resource Name (ARN) of the extension.
         * </p>
         * 
         * @param extensionIdentifier
         *        The name, the ID, or the Amazon Resource Name (ARN) of the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionIdentifier(String extensionIdentifier);

        /**
         * <p>
         * The version number for the extension defined in the association.
         * </p>
         * 
         * @param extensionVersionNumber
         *        The version number for the extension defined in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionVersionNumber(Integer extensionVersionNumber);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to start the list. Use this token to get the next set of results or pass null to get the first set of
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token to start the list. Use this token to get the next set of results or pass null to get the first
         *        set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String resourceIdentifier;

        private String extensionIdentifier;

        private Integer extensionVersionNumber;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExtensionAssociationsRequest model) {
            super(model);
            resourceIdentifier(model.resourceIdentifier);
            extensionIdentifier(model.extensionIdentifier);
            extensionVersionNumber(model.extensionVersionNumber);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getExtensionIdentifier() {
            return extensionIdentifier;
        }

        public final void setExtensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @Override
        public final Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            return this;
        }

        public final Integer getExtensionVersionNumber() {
            return extensionVersionNumber;
        }

        public final void setExtensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
        }

        @Override
        public final Builder extensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExtensionAssociationsRequest build() {
            return new ListExtensionAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
