/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an association between an extension and an AppConfig resource such as an application, environment,
 * or configuration profile. Call <code>GetExtensionAssociation</code> to get more information about an association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExtensionAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ExtensionAssociationSummary.Builder, ExtensionAssociationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ExtensionAssociationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> EXTENSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExtensionArn").getter(getter(ExtensionAssociationSummary::extensionArn))
            .setter(setter(Builder::extensionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionArn").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ExtensionAssociationSummary::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, EXTENSION_ARN_FIELD,
            RESOURCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String extensionArn;

    private final String resourceArn;

    private ExtensionAssociationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.extensionArn = builder.extensionArn;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The extension association ID. This ID is used to call other <code>ExtensionAssociation</code> API actions such as
     * <code>GetExtensionAssociation</code> or <code>DeleteExtensionAssociation</code>.
     * </p>
     * 
     * @return The extension association ID. This ID is used to call other <code>ExtensionAssociation</code> API actions
     *         such as <code>GetExtensionAssociation</code> or <code>DeleteExtensionAssociation</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The system-generated Amazon Resource Name (ARN) for the extension.
     * </p>
     * 
     * @return The system-generated Amazon Resource Name (ARN) for the extension.
     */
    public final String extensionArn() {
        return extensionArn;
    }

    /**
     * <p>
     * The ARNs of applications, configuration profiles, or environments defined in the association.
     * </p>
     * 
     * @return The ARNs of applications, configuration profiles, or environments defined in the association.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(extensionArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtensionAssociationSummary)) {
            return false;
        }
        ExtensionAssociationSummary other = (ExtensionAssociationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(extensionArn(), other.extensionArn())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExtensionAssociationSummary").add("Id", id()).add("ExtensionArn", extensionArn())
                .add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ExtensionArn":
            return Optional.ofNullable(clazz.cast(extensionArn()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExtensionAssociationSummary, T> g) {
        return obj -> g.apply((ExtensionAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExtensionAssociationSummary> {
        /**
         * <p>
         * The extension association ID. This ID is used to call other <code>ExtensionAssociation</code> API actions
         * such as <code>GetExtensionAssociation</code> or <code>DeleteExtensionAssociation</code>.
         * </p>
         * 
         * @param id
         *        The extension association ID. This ID is used to call other <code>ExtensionAssociation</code> API
         *        actions such as <code>GetExtensionAssociation</code> or <code>DeleteExtensionAssociation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The system-generated Amazon Resource Name (ARN) for the extension.
         * </p>
         * 
         * @param extensionArn
         *        The system-generated Amazon Resource Name (ARN) for the extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extensionArn(String extensionArn);

        /**
         * <p>
         * The ARNs of applications, configuration profiles, or environments defined in the association.
         * </p>
         * 
         * @param resourceArn
         *        The ARNs of applications, configuration profiles, or environments defined in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String extensionArn;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExtensionAssociationSummary model) {
            id(model.id);
            extensionArn(model.extensionArn);
            resourceArn(model.resourceArn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getExtensionArn() {
            return extensionArn;
        }

        public final void setExtensionArn(String extensionArn) {
            this.extensionArn = extensionArn;
        }

        @Override
        public final Builder extensionArn(String extensionArn) {
            this.extensionArn = extensionArn;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public ExtensionAssociationSummary build() {
            return new ExtensionAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
