/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDeploymentRequest extends AppConfigRequest implements
        ToCopyableBuilder<StopDeploymentRequest.Builder, StopDeploymentRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(StopDeploymentRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ApplicationId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentId").getter(getter(StopDeploymentRequest::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentId").build()).build();

    private static final SdkField<Integer> DEPLOYMENT_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeploymentNumber").getter(getter(StopDeploymentRequest::deploymentNumber))
            .setter(setter(Builder::deploymentNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DeploymentNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ENVIRONMENT_ID_FIELD, DEPLOYMENT_NUMBER_FIELD));

    private final String applicationId;

    private final String environmentId;

    private final Integer deploymentNumber;

    private StopDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.environmentId = builder.environmentId;
        this.deploymentNumber = builder.deploymentNumber;
    }

    /**
     * <p>
     * The application ID.
     * </p>
     * 
     * @return The application ID.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The environment ID.
     * </p>
     * 
     * @return The environment ID.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The sequence number of the deployment.
     * </p>
     * 
     * @return The sequence number of the deployment.
     */
    public final Integer deploymentNumber() {
        return deploymentNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDeploymentRequest)) {
            return false;
        }
        StopDeploymentRequest other = (StopDeploymentRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(deploymentNumber(), other.deploymentNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopDeploymentRequest").add("ApplicationId", applicationId())
                .add("EnvironmentId", environmentId()).add("DeploymentNumber", deploymentNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "EnvironmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "DeploymentNumber":
            return Optional.ofNullable(clazz.cast(deploymentNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopDeploymentRequest, T> g) {
        return obj -> g.apply((StopDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopDeploymentRequest> {
        /**
         * <p>
         * The application ID.
         * </p>
         * 
         * @param applicationId
         *        The application ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The environment ID.
         * </p>
         * 
         * @param environmentId
         *        The environment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The sequence number of the deployment.
         * </p>
         * 
         * @param deploymentNumber
         *        The sequence number of the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentNumber(Integer deploymentNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppConfigRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String environmentId;

        private Integer deploymentNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDeploymentRequest model) {
            super(model);
            applicationId(model.applicationId);
            environmentId(model.environmentId);
            deploymentNumber(model.deploymentNumber);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Integer getDeploymentNumber() {
            return deploymentNumber;
        }

        public final void setDeploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
        }

        @Override
        public final Builder deploymentNumber(Integer deploymentNumber) {
            this.deploymentNumber = deploymentNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopDeploymentRequest build() {
            return new StopDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
