/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.UpdateMethodRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateMethodRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("resource_id").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("http_method").isBinary(false).build();
    private static final MarshallingInfo<List> PATCHOPERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("patchOperations").isBinary(false).build();
    private static final UpdateMethodRequestModelMarshaller INSTANCE = new UpdateMethodRequestModelMarshaller();

    private UpdateMethodRequestModelMarshaller() {
    }

    public static UpdateMethodRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateMethodRequest updateMethodRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateMethodRequest), (String)"updateMethodRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateMethodRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)updateMethodRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)updateMethodRequest.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall(updateMethodRequest.patchOperations(), PATCHOPERATIONS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

