/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SdkConfigurationPropertyMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> FRIENDLYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("friendlyName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> REQUIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("required").isBinary(false).build();
    private static final MarshallingInfo<String> DEFAULTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultValue").isBinary(false).build();
    private static final SdkConfigurationPropertyMarshaller INSTANCE = new SdkConfigurationPropertyMarshaller();

    private SdkConfigurationPropertyMarshaller() {
    }

    public static SdkConfigurationPropertyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SdkConfigurationProperty sdkConfigurationProperty, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sdkConfigurationProperty, (String)"sdkConfigurationProperty");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sdkConfigurationProperty.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)sdkConfigurationProperty.friendlyName(), FRIENDLYNAME_BINDING);
            protocolMarshaller.marshall((Object)sdkConfigurationProperty.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)sdkConfigurationProperty.required(), REQUIRED_BINDING);
            protocolMarshaller.marshall((Object)sdkConfigurationProperty.defaultValue(), DEFAULTVALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

