/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.apigateway.model.Resource;
import software.amazon.awssdk.services.apigateway.transform.MethodUnmarshaller;

public class ResourceUnmarshaller
implements Unmarshaller<Resource, JsonUnmarshallerContext> {
    private static final ResourceUnmarshaller INSTANCE = new ResourceUnmarshaller();

    public Resource unmarshall(JsonUnmarshallerContext context) throws Exception {
        Resource.Builder resourceBuilder = Resource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    resourceBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("parentId", targetDepth)) {
                    context.nextToken();
                    resourceBuilder.parentId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("pathPart", targetDepth)) {
                    context.nextToken();
                    resourceBuilder.pathPart((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("path", targetDepth)) {
                    context.nextToken();
                    resourceBuilder.path((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceMethods", targetDepth)) {
                    context.nextToken();
                    resourceBuilder.resourceMethods(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)MethodUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Resource)resourceBuilder.build();
    }

    public static ResourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

