/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.QuotaSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QuotaSettingsMarshaller {
    private static final MarshallingInfo<Integer> LIMIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("limit").isBinary(false).build();
    private static final MarshallingInfo<Integer> OFFSET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("offset").isBinary(false).build();
    private static final MarshallingInfo<String> PERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("period").isBinary(false).build();
    private static final QuotaSettingsMarshaller INSTANCE = new QuotaSettingsMarshaller();

    private QuotaSettingsMarshaller() {
    }

    public static QuotaSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QuotaSettings quotaSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)quotaSettings, (String)"quotaSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)quotaSettings.limit(), LIMIT_BINDING);
            protocolMarshaller.marshall((Object)quotaSettings.offset(), OFFSET_BINDING);
            protocolMarshaller.marshall((Object)quotaSettings.periodAsString(), PERIOD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

