/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.apigateway.model.PutMethodResponseRequest;
import software.amazon.awssdk.services.apigateway.transform.PutMethodResponseRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutMethodResponseRequestMarshaller
implements Marshaller<Request<PutMethodResponseRequest>, PutMethodResponseRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}").httpMethodName(HttpMethodName.PUT).hasExplicitPayloadMember(false).hasPayloadMembers(true).build();
    private final AwsJsonProtocolFactory protocolFactory;

    public PutMethodResponseRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutMethodResponseRequest> marshall(PutMethodResponseRequest putMethodResponseRequest) {
        Validate.paramNotNull((Object)((Object)putMethodResponseRequest), (String)"putMethodResponseRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)putMethodResponseRequest);
            protocolMarshaller.startMarshalling();
            PutMethodResponseRequestModelMarshaller.getInstance().marshall(putMethodResponseRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

