/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.PutMethodRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutMethodRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("resource_id").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("http_method").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationType").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> APIKEYREQUIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeyRequired").isBinary(false).build();
    private static final MarshallingInfo<String> OPERATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationName").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTMODELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestModels").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTVALIDATORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestValidatorId").isBinary(false).build();
    private static final PutMethodRequestModelMarshaller INSTANCE = new PutMethodRequestModelMarshaller();

    private PutMethodRequestModelMarshaller() {
    }

    public static PutMethodRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutMethodRequest putMethodRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putMethodRequest), (String)"putMethodRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putMethodRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)putMethodRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)putMethodRequest.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)putMethodRequest.authorizationType(), AUTHORIZATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)putMethodRequest.authorizerId(), AUTHORIZERID_BINDING);
            protocolMarshaller.marshall((Object)putMethodRequest.apiKeyRequired(), APIKEYREQUIRED_BINDING);
            protocolMarshaller.marshall((Object)putMethodRequest.operationName(), OPERATIONNAME_BINDING);
            protocolMarshaller.marshall(putMethodRequest.requestParameters(), REQUESTPARAMETERS_BINDING);
            protocolMarshaller.marshall(putMethodRequest.requestModels(), REQUESTMODELS_BINDING);
            protocolMarshaller.marshall((Object)putMethodRequest.requestValidatorId(), REQUESTVALIDATORID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

