/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.PatchOperation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PatchOperationMarshaller {
    private static final MarshallingInfo<String> OP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("op").isBinary(false).build();
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("path").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final MarshallingInfo<String> FROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("from").isBinary(false).build();
    private static final PatchOperationMarshaller INSTANCE = new PatchOperationMarshaller();

    private PatchOperationMarshaller() {
    }

    public static PatchOperationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PatchOperation patchOperation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)patchOperation, (String)"patchOperation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)patchOperation.opAsString(), OP_BINDING);
            protocolMarshaller.marshall((Object)patchOperation.path(), PATH_BINDING);
            protocolMarshaller.marshall((Object)patchOperation.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)patchOperation.from(), FROM_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

