/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.model.Method;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MethodMarshaller {
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpMethod").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizationType").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerId").isBinary(false).build();
    private static final MarshallingInfo<Boolean> APIKEYREQUIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiKeyRequired").isBinary(false).build();
    private static final MarshallingInfo<String> REQUESTVALIDATORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestValidatorId").isBinary(false).build();
    private static final MarshallingInfo<String> OPERATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operationName").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTMODELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestModels").isBinary(false).build();
    private static final MarshallingInfo<Map> METHODRESPONSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("methodResponses").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> METHODINTEGRATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("methodIntegration").isBinary(false).build();
    private static final MethodMarshaller INSTANCE = new MethodMarshaller();

    private MethodMarshaller() {
    }

    public static MethodMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Method method, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)method, (String)"method");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)method.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)method.authorizationType(), AUTHORIZATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)method.authorizerId(), AUTHORIZERID_BINDING);
            protocolMarshaller.marshall((Object)method.apiKeyRequired(), APIKEYREQUIRED_BINDING);
            protocolMarshaller.marshall((Object)method.requestValidatorId(), REQUESTVALIDATORID_BINDING);
            protocolMarshaller.marshall((Object)method.operationName(), OPERATIONNAME_BINDING);
            protocolMarshaller.marshall(method.requestParameters(), REQUESTPARAMETERS_BINDING);
            protocolMarshaller.marshall(method.requestModels(), REQUESTMODELS_BINDING);
            protocolMarshaller.marshall(method.methodResponses(), METHODRESPONSES_BINDING);
            protocolMarshaller.marshall((Object)method.methodIntegration(), METHODINTEGRATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

