/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.apigateway.model.Integration;
import software.amazon.awssdk.services.apigateway.transform.IntegrationResponseUnmarshaller;

public class IntegrationUnmarshaller
implements Unmarshaller<Integration, JsonUnmarshallerContext> {
    private static final IntegrationUnmarshaller INSTANCE = new IntegrationUnmarshaller();

    public Integration unmarshall(JsonUnmarshallerContext context) throws Exception {
        Integration.Builder integrationBuilder = Integration.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("httpMethod", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.httpMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("uri", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.uri((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("credentials", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.credentials((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("requestParameters", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.requestParameters(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("requestTemplates", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.requestTemplates(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("passthroughBehavior", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.passthroughBehavior((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("contentHandling", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.contentHandling((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("cacheNamespace", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.cacheNamespace((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("cacheKeyParameters", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.cacheKeyParameters(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("integrationResponses", targetDepth)) {
                    context.nextToken();
                    integrationBuilder.integrationResponses(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)IntegrationResponseUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Integration)integrationBuilder.build();
    }

    public static IntegrationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

