/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.Integration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IntegrationMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("httpMethod").isBinary(false).build();
    private static final MarshallingInfo<String> URI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uri").isBinary(false).build();
    private static final MarshallingInfo<String> CREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("credentials").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> REQUESTTEMPLATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("requestTemplates").isBinary(false).build();
    private static final MarshallingInfo<String> PASSTHROUGHBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("passthroughBehavior").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTHANDLING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentHandling").isBinary(false).build();
    private static final MarshallingInfo<String> CACHENAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheNamespace").isBinary(false).build();
    private static final MarshallingInfo<List> CACHEKEYPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheKeyParameters").isBinary(false).build();
    private static final MarshallingInfo<Map> INTEGRATIONRESPONSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("integrationResponses").isBinary(false).build();
    private static final IntegrationMarshaller INSTANCE = new IntegrationMarshaller();

    private IntegrationMarshaller() {
    }

    public static IntegrationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Integration integration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)integration, (String)"integration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)integration.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)integration.httpMethod(), HTTPMETHOD_BINDING);
            protocolMarshaller.marshall((Object)integration.uri(), URI_BINDING);
            protocolMarshaller.marshall((Object)integration.credentials(), CREDENTIALS_BINDING);
            protocolMarshaller.marshall(integration.requestParameters(), REQUESTPARAMETERS_BINDING);
            protocolMarshaller.marshall(integration.requestTemplates(), REQUESTTEMPLATES_BINDING);
            protocolMarshaller.marshall((Object)integration.passthroughBehavior(), PASSTHROUGHBEHAVIOR_BINDING);
            protocolMarshaller.marshall((Object)integration.contentHandlingAsString(), CONTENTHANDLING_BINDING);
            protocolMarshaller.marshall((Object)integration.cacheNamespace(), CACHENAMESPACE_BINDING);
            protocolMarshaller.marshall(integration.cacheKeyParameters(), CACHEKEYPARAMETERS_BINDING);
            protocolMarshaller.marshall(integration.integrationResponses(), INTEGRATIONRESPONSES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

