/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.GetMethodRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetMethodRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("resource_id").isBinary(false).build();
    private static final MarshallingInfo<String> HTTPMETHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("http_method").isBinary(false).build();
    private static final GetMethodRequestModelMarshaller INSTANCE = new GetMethodRequestModelMarshaller();

    private GetMethodRequestModelMarshaller() {
    }

    public static GetMethodRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetMethodRequest getMethodRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getMethodRequest), (String)"getMethodRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getMethodRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)getMethodRequest.resourceId(), RESOURCEID_BINDING);
            protocolMarshaller.marshall((Object)getMethodRequest.httpMethod(), HTTPMETHOD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

