/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.CreateStageRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateStageRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageName").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CACHECLUSTERENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> CACHECLUSTERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterSize").isBinary(false).build();
    private static final MarshallingInfo<Map> VARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("variables").isBinary(false).build();
    private static final MarshallingInfo<String> DOCUMENTATIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("documentationVersion").isBinary(false).build();
    private static final CreateStageRequestModelMarshaller INSTANCE = new CreateStageRequestModelMarshaller();

    private CreateStageRequestModelMarshaller() {
    }

    public static CreateStageRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateStageRequest createStageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createStageRequest), (String)"createStageRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createStageRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)createStageRequest.stageName(), STAGENAME_BINDING);
            protocolMarshaller.marshall((Object)createStageRequest.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)createStageRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createStageRequest.cacheClusterEnabled(), CACHECLUSTERENABLED_BINDING);
            protocolMarshaller.marshall((Object)createStageRequest.cacheClusterSize(), CACHECLUSTERSIZE_BINDING);
            protocolMarshaller.marshall(createStageRequest.variables(), VARIABLES_BINDING);
            protocolMarshaller.marshall((Object)createStageRequest.documentationVersion(), DOCUMENTATIONVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

