/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.CreateDeploymentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDeploymentRequestModelMarshaller {
    private static final MarshallingInfo<String> RESTAPIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("restapi_id").isBinary(false).build();
    private static final MarshallingInfo<String> STAGENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageName").isBinary(false).build();
    private static final MarshallingInfo<String> STAGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageDescription").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CACHECLUSTERENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterEnabled").isBinary(false).build();
    private static final MarshallingInfo<String> CACHECLUSTERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cacheClusterSize").isBinary(false).build();
    private static final MarshallingInfo<Map> VARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("variables").isBinary(false).build();
    private static final CreateDeploymentRequestModelMarshaller INSTANCE = new CreateDeploymentRequestModelMarshaller();

    private CreateDeploymentRequestModelMarshaller() {
    }

    public static CreateDeploymentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDeploymentRequest createDeploymentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDeploymentRequest), (String)"createDeploymentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDeploymentRequest.restApiId(), RESTAPIID_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.stageName(), STAGENAME_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.stageDescription(), STAGEDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.cacheClusterEnabled(), CACHECLUSTERENABLED_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.cacheClusterSize(), CACHECLUSTERSIZE_BINDING);
            protocolMarshaller.marshall(createDeploymentRequest.variables(), VARIABLES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

