/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.Authorizer;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AuthorizerMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<List> PROVIDERARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("providerARNs").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authType").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERURI_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerUri").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHORIZERCREDENTIALS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerCredentials").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTITYSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("identitySource").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTITYVALIDATIONEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("identityValidationExpression").isBinary(false).build();
    private static final MarshallingInfo<Integer> AUTHORIZERRESULTTTLINSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authorizerResultTtlInSeconds").isBinary(false).build();
    private static final AuthorizerMarshaller INSTANCE = new AuthorizerMarshaller();

    private AuthorizerMarshaller() {
    }

    public static AuthorizerMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Authorizer authorizer, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)authorizer, (String)"authorizer");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)authorizer.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)authorizer.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)authorizer.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall(authorizer.providerARNs(), PROVIDERARNS_BINDING);
            protocolMarshaller.marshall((Object)authorizer.authType(), AUTHTYPE_BINDING);
            protocolMarshaller.marshall((Object)authorizer.authorizerUri(), AUTHORIZERURI_BINDING);
            protocolMarshaller.marshall((Object)authorizer.authorizerCredentials(), AUTHORIZERCREDENTIALS_BINDING);
            protocolMarshaller.marshall((Object)authorizer.identitySource(), IDENTITYSOURCE_BINDING);
            protocolMarshaller.marshall((Object)authorizer.identityValidationExpression(), IDENTITYVALIDATIONEXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)authorizer.authorizerResultTtlInSeconds(), AUTHORIZERRESULTTTLINSECONDS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

