/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.ApiStage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApiStageMarshaller {
    private static final MarshallingInfo<String> APIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("apiId").isBinary(false).build();
    private static final MarshallingInfo<String> STAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stage").isBinary(false).build();
    private static final ApiStageMarshaller INSTANCE = new ApiStageMarshaller();

    private ApiStageMarshaller() {
    }

    public static ApiStageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApiStage apiStage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)apiStage, (String)"apiStage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)apiStage.apiId(), APIID_BINDING);
            protocolMarshaller.marshall((Object)apiStage.stage(), STAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

