/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.apigateway.model.ApiKey;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApiKeyMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> CUSTOMERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customerId").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("enabled").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTUPDATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedDate").isBinary(false).build();
    private static final MarshallingInfo<List> STAGEKEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stageKeys").isBinary(false).build();
    private static final ApiKeyMarshaller INSTANCE = new ApiKeyMarshaller();

    private ApiKeyMarshaller() {
    }

    public static ApiKeyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApiKey apiKey, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)apiKey, (String)"apiKey");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)apiKey.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)apiKey.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)apiKey.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)apiKey.customerId(), CUSTOMERID_BINDING);
            protocolMarshaller.marshall((Object)apiKey.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)apiKey.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)apiKey.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)apiKey.lastUpdatedDate(), LASTUPDATEDDATE_BINDING);
            protocolMarshaller.marshall(apiKey.stageKeys(), STAGEKEYS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

