/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.Integration;
import software.amazon.awssdk.services.apigateway.model.MapOfMethodResponseCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToBooleanCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.MethodResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMethodResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateMethodResponse> {
    private final String httpMethod;
    private final String authorizationType;
    private final String authorizerId;
    private final Boolean apiKeyRequired;
    private final String requestValidatorId;
    private final String operationName;
    private final Map<String, Boolean> requestParameters;
    private final Map<String, String> requestModels;
    private final Map<String, MethodResponse> methodResponses;
    private final Integration methodIntegration;

    private UpdateMethodResponse(BuilderImpl builder) {
        super(builder);
        this.httpMethod = builder.httpMethod;
        this.authorizationType = builder.authorizationType;
        this.authorizerId = builder.authorizerId;
        this.apiKeyRequired = builder.apiKeyRequired;
        this.requestValidatorId = builder.requestValidatorId;
        this.operationName = builder.operationName;
        this.requestParameters = builder.requestParameters;
        this.requestModels = builder.requestModels;
        this.methodResponses = builder.methodResponses;
        this.methodIntegration = builder.methodIntegration;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String authorizationType() {
        return this.authorizationType;
    }

    public String authorizerId() {
        return this.authorizerId;
    }

    public Boolean apiKeyRequired() {
        return this.apiKeyRequired;
    }

    public String requestValidatorId() {
        return this.requestValidatorId;
    }

    public String operationName() {
        return this.operationName;
    }

    public Map<String, Boolean> requestParameters() {
        return this.requestParameters;
    }

    public Map<String, String> requestModels() {
        return this.requestModels;
    }

    public Map<String, MethodResponse> methodResponses() {
        return this.methodResponses;
    }

    public Integration methodIntegration() {
        return this.methodIntegration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestValidatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestModels());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodIntegration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMethodResponse)) {
            return false;
        }
        UpdateMethodResponse other = (UpdateMethodResponse)((Object)obj);
        return Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.authorizationType(), other.authorizationType()) && Objects.equals(this.authorizerId(), other.authorizerId()) && Objects.equals(this.apiKeyRequired(), other.apiKeyRequired()) && Objects.equals(this.requestValidatorId(), other.requestValidatorId()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.requestParameters(), other.requestParameters()) && Objects.equals(this.requestModels(), other.requestModels()) && Objects.equals(this.methodResponses(), other.methodResponses()) && Objects.equals(this.methodIntegration(), other.methodIntegration());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMethodResponse").add("HttpMethod", (Object)this.httpMethod()).add("AuthorizationType", (Object)this.authorizationType()).add("AuthorizerId", (Object)this.authorizerId()).add("ApiKeyRequired", (Object)this.apiKeyRequired()).add("RequestValidatorId", (Object)this.requestValidatorId()).add("OperationName", (Object)this.operationName()).add("RequestParameters", this.requestParameters()).add("RequestModels", this.requestModels()).add("MethodResponses", this.methodResponses()).add("MethodIntegration", (Object)this.methodIntegration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "authorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationType()));
            }
            case "authorizerId": {
                return Optional.ofNullable(clazz.cast(this.authorizerId()));
            }
            case "apiKeyRequired": {
                return Optional.ofNullable(clazz.cast(this.apiKeyRequired()));
            }
            case "requestValidatorId": {
                return Optional.ofNullable(clazz.cast(this.requestValidatorId()));
            }
            case "operationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "requestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "requestModels": {
                return Optional.ofNullable(clazz.cast(this.requestModels()));
            }
            case "methodResponses": {
                return Optional.ofNullable(clazz.cast(this.methodResponses()));
            }
            case "methodIntegration": {
                return Optional.ofNullable(clazz.cast(this.methodIntegration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String httpMethod;
        private String authorizationType;
        private String authorizerId;
        private Boolean apiKeyRequired;
        private String requestValidatorId;
        private String operationName;
        private Map<String, Boolean> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestModels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, MethodResponse> methodResponses = DefaultSdkAutoConstructMap.getInstance();
        private Integration methodIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMethodResponse model) {
            super(model);
            this.httpMethod(model.httpMethod);
            this.authorizationType(model.authorizationType);
            this.authorizerId(model.authorizerId);
            this.apiKeyRequired(model.apiKeyRequired);
            this.requestValidatorId(model.requestValidatorId);
            this.operationName(model.operationName);
            this.requestParameters(model.requestParameters);
            this.requestModels(model.requestModels);
            this.methodResponses(model.methodResponses);
            this.methodIntegration(model.methodIntegration);
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        public final String getRequestValidatorId() {
            return this.requestValidatorId;
        }

        @Override
        public final Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public final void setRequestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public final Map<String, Boolean> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestModels() {
            return this.requestModels;
        }

        @Override
        public final Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
            return this;
        }

        public final void setRequestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
        }

        public final Map<String, MethodResponse.Builder> getMethodResponses() {
            return this.methodResponses != null ? CollectionUtils.mapValues(this.methodResponses, MethodResponse::toBuilder) : null;
        }

        @Override
        public final Builder methodResponses(Map<String, MethodResponse> methodResponses) {
            this.methodResponses = MapOfMethodResponseCopier.copy(methodResponses);
            return this;
        }

        public final void setMethodResponses(Map<String, MethodResponse.BuilderImpl> methodResponses) {
            this.methodResponses = MapOfMethodResponseCopier.copyFromBuilder(methodResponses);
        }

        public final Integration.Builder getMethodIntegration() {
            return this.methodIntegration != null ? this.methodIntegration.toBuilder() : null;
        }

        @Override
        public final Builder methodIntegration(Integration methodIntegration) {
            this.methodIntegration = methodIntegration;
            return this;
        }

        public final void setMethodIntegration(Integration.BuilderImpl methodIntegration) {
            this.methodIntegration = methodIntegration != null ? methodIntegration.build() : null;
        }

        @Override
        public UpdateMethodResponse build() {
            return new UpdateMethodResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, UpdateMethodResponse> {
        public Builder httpMethod(String var1);

        public Builder authorizationType(String var1);

        public Builder authorizerId(String var1);

        public Builder apiKeyRequired(Boolean var1);

        public Builder requestValidatorId(String var1);

        public Builder operationName(String var1);

        public Builder requestParameters(Map<String, Boolean> var1);

        public Builder requestModels(Map<String, String> var1);

        public Builder methodResponses(Map<String, MethodResponse> var1);

        public Builder methodIntegration(Integration var1);

        default public Builder methodIntegration(Consumer<Integration.Builder> methodIntegration) {
            return this.methodIntegration((Integration)((Integration.Builder)Integration.builder().applyMutation(methodIntegration)).build());
        }
    }
}

