/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ListOfPatchOperationCopier;
import software.amazon.awssdk.services.apigateway.model.PatchOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDocumentationPartRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, UpdateDocumentationPartRequest> {
    private final String restApiId;
    private final String documentationPartId;
    private final List<PatchOperation> patchOperations;

    private UpdateDocumentationPartRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.documentationPartId = builder.documentationPartId;
        this.patchOperations = builder.patchOperations;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String documentationPartId() {
        return this.documentationPartId;
    }

    public List<PatchOperation> patchOperations() {
        return this.patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationPartId());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchOperations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentationPartRequest)) {
            return false;
        }
        UpdateDocumentationPartRequest other = (UpdateDocumentationPartRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.documentationPartId(), other.documentationPartId()) && Objects.equals(this.patchOperations(), other.patchOperations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDocumentationPartRequest").add("RestApiId", (Object)this.restApiId()).add("DocumentationPartId", (Object)this.documentationPartId()).add("PatchOperations", this.patchOperations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "documentationPartId": {
                return Optional.ofNullable(clazz.cast(this.documentationPartId()));
            }
            case "patchOperations": {
                return Optional.ofNullable(clazz.cast(this.patchOperations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String documentationPartId;
        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentationPartRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.documentationPartId(model.documentationPartId);
            this.patchOperations(model.patchOperations);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getDocumentationPartId() {
            return this.documentationPartId;
        }

        @Override
        public final Builder documentationPartId(String documentationPartId) {
            this.documentationPartId = documentationPartId;
            return this;
        }

        public final void setDocumentationPartId(String documentationPartId) {
            this.documentationPartId = documentationPartId;
        }

        public final Collection<PatchOperation.Builder> getPatchOperations() {
            return this.patchOperations != null ? (Collection)this.patchOperations.stream().map(PatchOperation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(PatchOperation ... patchOperations) {
            this.patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder> ... patchOperations) {
            this.patchOperations(Stream.of(patchOperations).map(c -> (PatchOperation)((PatchOperation.Builder)PatchOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDocumentationPartRequest build() {
            return new UpdateDocumentationPartRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, UpdateDocumentationPartRequest> {
        public Builder restApiId(String var1);

        public Builder documentationPartId(String var1);

        public Builder patchOperations(Collection<PatchOperation> var1);

        public Builder patchOperations(PatchOperation ... var1);

        public Builder patchOperations(Consumer<PatchOperation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

