/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApiKeyResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateApiKeyResponse> {
    private final String id;
    private final String value;
    private final String name;
    private final String customerId;
    private final String description;
    private final Boolean enabled;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;
    private final List<String> stageKeys;

    private UpdateApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.value = builder.value;
        this.name = builder.name;
        this.customerId = builder.customerId;
        this.description = builder.description;
        this.enabled = builder.enabled;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.stageKeys = builder.stageKeys;
    }

    public String id() {
        return this.id;
    }

    public String value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public String customerId() {
        return this.customerId;
    }

    public String description() {
        return this.description;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public List<String> stageKeys() {
        return this.stageKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageKeys());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApiKeyResponse)) {
            return false;
        }
        UpdateApiKeyResponse other = (UpdateApiKeyResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.customerId(), other.customerId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.stageKeys(), other.stageKeys());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApiKeyResponse").add("Id", (Object)this.id()).add("Value", (Object)this.value()).add("Name", (Object)this.name()).add("CustomerId", (Object)this.customerId()).add("Description", (Object)this.description()).add("Enabled", (Object)this.enabled()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("StageKeys", this.stageKeys()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "customerId": {
                return Optional.ofNullable(clazz.cast(this.customerId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "stageKeys": {
                return Optional.ofNullable(clazz.cast(this.stageKeys()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String value;
        private String name;
        private String customerId;
        private String description;
        private Boolean enabled;
        private Instant createdDate;
        private Instant lastUpdatedDate;
        private List<String> stageKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApiKeyResponse model) {
            super(model);
            this.id(model.id);
            this.value(model.value);
            this.name(model.name);
            this.customerId(model.customerId);
            this.description(model.description);
            this.enabled(model.enabled);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.stageKeys(model.stageKeys);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCustomerId() {
            return this.customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Collection<String> getStageKeys() {
            return this.stageKeys;
        }

        @Override
        public final Builder stageKeys(Collection<String> stageKeys) {
            this.stageKeys = ListOfStringCopier.copy(stageKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stageKeys(String ... stageKeys) {
            this.stageKeys(Arrays.asList(stageKeys));
            return this;
        }

        public final void setStageKeys(Collection<String> stageKeys) {
            this.stageKeys = ListOfStringCopier.copy(stageKeys);
        }

        @Override
        public UpdateApiKeyResponse build() {
            return new UpdateApiKeyResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, UpdateApiKeyResponse> {
        public Builder id(String var1);

        public Builder value(String var1);

        public Builder name(String var1);

        public Builder customerId(String var1);

        public Builder description(String var1);

        public Builder enabled(Boolean var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder stageKeys(Collection<String> var1);

        public Builder stageKeys(String ... var1);
    }
}

