/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfHeaderValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeMethodResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, TestInvokeMethodResponse> {
    private final Integer status;
    private final String body;
    private final Map<String, String> headers;
    private final String log;
    private final Long latency;

    private TestInvokeMethodResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.body = builder.body;
        this.headers = builder.headers;
        this.log = builder.log;
        this.latency = builder.latency;
    }

    public Integer status() {
        return this.status;
    }

    public String body() {
        return this.body;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public String log() {
        return this.log;
    }

    public Long latency() {
        return this.latency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.headers());
        hashCode = 31 * hashCode + Objects.hashCode(this.log());
        hashCode = 31 * hashCode + Objects.hashCode(this.latency());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeMethodResponse)) {
            return false;
        }
        TestInvokeMethodResponse other = (TestInvokeMethodResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.log(), other.log()) && Objects.equals(this.latency(), other.latency());
    }

    public String toString() {
        return ToString.builder((String)"TestInvokeMethodResponse").add("Status", (Object)this.status()).add("Body", (Object)this.body()).add("Headers", this.headers()).add("Log", (Object)this.log()).add("Latency", (Object)this.latency()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "log": {
                return Optional.ofNullable(clazz.cast(this.log()));
            }
            case "latency": {
                return Optional.ofNullable(clazz.cast(this.latency()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private String body;
        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();
        private String log;
        private Long latency;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeMethodResponse model) {
            super(model);
            this.status(model.status);
            this.body(model.body);
            this.headers(model.headers);
            this.log(model.log);
            this.latency(model.latency);
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = MapOfHeaderValuesCopier.copy(headers);
            return this;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = MapOfHeaderValuesCopier.copy(headers);
        }

        public final String getLog() {
            return this.log;
        }

        @Override
        public final Builder log(String log) {
            this.log = log;
            return this;
        }

        public final void setLog(String log) {
            this.log = log;
        }

        public final Long getLatency() {
            return this.latency;
        }

        @Override
        public final Builder latency(Long latency) {
            this.latency = latency;
            return this;
        }

        public final void setLatency(Long latency) {
            this.latency = latency;
        }

        @Override
        public TestInvokeMethodResponse build() {
            return new TestInvokeMethodResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, TestInvokeMethodResponse> {
        public Builder status(Integer var1);

        public Builder body(String var1);

        public Builder headers(Map<String, String> var1);

        public Builder log(String var1);

        public Builder latency(Long var1);
    }
}

