/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToBooleanCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMethodRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, PutMethodRequest> {
    private final String restApiId;
    private final String resourceId;
    private final String httpMethod;
    private final String authorizationType;
    private final String authorizerId;
    private final Boolean apiKeyRequired;
    private final String operationName;
    private final Map<String, Boolean> requestParameters;
    private final Map<String, String> requestModels;
    private final String requestValidatorId;

    private PutMethodRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.httpMethod = builder.httpMethod;
        this.authorizationType = builder.authorizationType;
        this.authorizerId = builder.authorizerId;
        this.apiKeyRequired = builder.apiKeyRequired;
        this.operationName = builder.operationName;
        this.requestParameters = builder.requestParameters;
        this.requestModels = builder.requestModels;
        this.requestValidatorId = builder.requestValidatorId;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String authorizationType() {
        return this.authorizationType;
    }

    public String authorizerId() {
        return this.authorizerId;
    }

    public Boolean apiKeyRequired() {
        return this.apiKeyRequired;
    }

    public String operationName() {
        return this.operationName;
    }

    public Map<String, Boolean> requestParameters() {
        return this.requestParameters;
    }

    public Map<String, String> requestModels() {
        return this.requestModels;
    }

    public String requestValidatorId() {
        return this.requestValidatorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestModels());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestValidatorId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMethodRequest)) {
            return false;
        }
        PutMethodRequest other = (PutMethodRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.authorizationType(), other.authorizationType()) && Objects.equals(this.authorizerId(), other.authorizerId()) && Objects.equals(this.apiKeyRequired(), other.apiKeyRequired()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.requestParameters(), other.requestParameters()) && Objects.equals(this.requestModels(), other.requestModels()) && Objects.equals(this.requestValidatorId(), other.requestValidatorId());
    }

    public String toString() {
        return ToString.builder((String)"PutMethodRequest").add("RestApiId", (Object)this.restApiId()).add("ResourceId", (Object)this.resourceId()).add("HttpMethod", (Object)this.httpMethod()).add("AuthorizationType", (Object)this.authorizationType()).add("AuthorizerId", (Object)this.authorizerId()).add("ApiKeyRequired", (Object)this.apiKeyRequired()).add("OperationName", (Object)this.operationName()).add("RequestParameters", this.requestParameters()).add("RequestModels", this.requestModels()).add("RequestValidatorId", (Object)this.requestValidatorId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "authorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationType()));
            }
            case "authorizerId": {
                return Optional.ofNullable(clazz.cast(this.authorizerId()));
            }
            case "apiKeyRequired": {
                return Optional.ofNullable(clazz.cast(this.apiKeyRequired()));
            }
            case "operationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "requestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "requestModels": {
                return Optional.ofNullable(clazz.cast(this.requestModels()));
            }
            case "requestValidatorId": {
                return Optional.ofNullable(clazz.cast(this.requestValidatorId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String resourceId;
        private String httpMethod;
        private String authorizationType;
        private String authorizerId;
        private Boolean apiKeyRequired;
        private String operationName;
        private Map<String, Boolean> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestModels = DefaultSdkAutoConstructMap.getInstance();
        private String requestValidatorId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMethodRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.resourceId(model.resourceId);
            this.httpMethod(model.httpMethod);
            this.authorizationType(model.authorizationType);
            this.authorizerId(model.authorizerId);
            this.apiKeyRequired(model.apiKeyRequired);
            this.operationName(model.operationName);
            this.requestParameters(model.requestParameters);
            this.requestModels(model.requestModels);
            this.requestValidatorId(model.requestValidatorId);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public final Map<String, Boolean> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestModels() {
            return this.requestModels;
        }

        @Override
        public final Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
            return this;
        }

        public final void setRequestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
        }

        public final String getRequestValidatorId() {
            return this.requestValidatorId;
        }

        @Override
        public final Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public final void setRequestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMethodRequest build() {
            return new PutMethodRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, PutMethodRequest> {
        public Builder restApiId(String var1);

        public Builder resourceId(String var1);

        public Builder httpMethod(String var1);

        public Builder authorizationType(String var1);

        public Builder authorizerId(String var1);

        public Builder apiKeyRequired(Boolean var1);

        public Builder operationName(String var1);

        public Builder requestParameters(Map<String, Boolean> var1);

        public Builder requestModels(Map<String, String> var1);

        public Builder requestValidatorId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

