/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.GatewayResponseType;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutGatewayResponseRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, PutGatewayResponseRequest> {
    private final String restApiId;
    private final String responseType;
    private final String statusCode;
    private final Map<String, String> responseParameters;
    private final Map<String, String> responseTemplates;

    private PutGatewayResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.responseType = builder.responseType;
        this.statusCode = builder.statusCode;
        this.responseParameters = builder.responseParameters;
        this.responseTemplates = builder.responseTemplates;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public GatewayResponseType responseType() {
        return GatewayResponseType.fromValue(this.responseType);
    }

    public String responseTypeAsString() {
        return this.responseType;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public Map<String, String> responseParameters() {
        return this.responseParameters;
    }

    public Map<String, String> responseTemplates() {
        return this.responseTemplates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTemplates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGatewayResponseRequest)) {
            return false;
        }
        PutGatewayResponseRequest other = (PutGatewayResponseRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.responseTypeAsString(), other.responseTypeAsString()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.responseTemplates(), other.responseTemplates());
    }

    public String toString() {
        return ToString.builder((String)"PutGatewayResponseRequest").add("RestApiId", (Object)this.restApiId()).add("ResponseType", (Object)this.responseTypeAsString()).add("StatusCode", (Object)this.statusCode()).add("ResponseParameters", this.responseParameters()).add("ResponseTemplates", this.responseTemplates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "responseType": {
                return Optional.ofNullable(clazz.cast(this.responseTypeAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "responseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "responseTemplates": {
                return Optional.ofNullable(clazz.cast(this.responseTemplates()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String responseType;
        private String statusCode;
        private Map<String, String> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseTemplates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutGatewayResponseRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.responseType(model.responseType);
            this.statusCode(model.statusCode);
            this.responseParameters(model.responseParameters);
            this.responseTemplates(model.responseTemplates);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getResponseType() {
            return this.responseType;
        }

        @Override
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public final Builder responseType(GatewayResponseType responseType) {
            this.responseType(responseType.toString());
            return this;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final Map<String, String> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, String> responseParameters) {
            this.responseParameters = MapOfStringToStringCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseTemplates() {
            return this.responseTemplates;
        }

        @Override
        public final Builder responseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
            return this;
        }

        public final void setResponseTemplates(Map<String, String> responseTemplates) {
            this.responseTemplates = MapOfStringToStringCopier.copy(responseTemplates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGatewayResponseRequest build() {
            return new PutGatewayResponseRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, PutGatewayResponseRequest> {
        public Builder restApiId(String var1);

        public Builder responseType(String var1);

        public Builder responseType(GatewayResponseType var1);

        public Builder statusCode(String var1);

        public Builder responseParameters(Map<String, String> var1);

        public Builder responseTemplates(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

