/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.CacheClusterStatus;
import software.amazon.awssdk.services.apigateway.model.MapOfMethodSettingsCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.MethodSetting;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStageResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetStageResponse> {
    private final String deploymentId;
    private final String clientCertificateId;
    private final String stageName;
    private final String description;
    private final Boolean cacheClusterEnabled;
    private final String cacheClusterSize;
    private final String cacheClusterStatus;
    private final Map<String, MethodSetting> methodSettings;
    private final Map<String, String> variables;
    private final String documentationVersion;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;

    private GetStageResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.clientCertificateId = builder.clientCertificateId;
        this.stageName = builder.stageName;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.cacheClusterStatus = builder.cacheClusterStatus;
        this.methodSettings = builder.methodSettings;
        this.variables = builder.variables;
        this.documentationVersion = builder.documentationVersion;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String clientCertificateId() {
        return this.clientCertificateId;
    }

    public String stageName() {
        return this.stageName;
    }

    public String description() {
        return this.description;
    }

    public Boolean cacheClusterEnabled() {
        return this.cacheClusterEnabled;
    }

    public String cacheClusterSize() {
        return this.cacheClusterSize;
    }

    public CacheClusterStatus cacheClusterStatus() {
        return CacheClusterStatus.fromValue(this.cacheClusterStatus);
    }

    public String cacheClusterStatusAsString() {
        return this.cacheClusterStatus;
    }

    public Map<String, MethodSetting> methodSettings() {
        return this.methodSettings;
    }

    public Map<String, String> variables() {
        return this.variables;
    }

    public String documentationVersion() {
        return this.documentationVersion;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStageResponse)) {
            return false;
        }
        GetStageResponse other = (GetStageResponse)((Object)obj);
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.clientCertificateId(), other.clientCertificateId()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cacheClusterEnabled(), other.cacheClusterEnabled()) && Objects.equals(this.cacheClusterSize(), other.cacheClusterSize()) && Objects.equals(this.cacheClusterStatusAsString(), other.cacheClusterStatusAsString()) && Objects.equals(this.methodSettings(), other.methodSettings()) && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.documentationVersion(), other.documentationVersion()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate());
    }

    public String toString() {
        return ToString.builder((String)"GetStageResponse").add("DeploymentId", (Object)this.deploymentId()).add("ClientCertificateId", (Object)this.clientCertificateId()).add("StageName", (Object)this.stageName()).add("Description", (Object)this.description()).add("CacheClusterEnabled", (Object)this.cacheClusterEnabled()).add("CacheClusterSize", (Object)this.cacheClusterSize()).add("CacheClusterStatus", (Object)this.cacheClusterStatusAsString()).add("MethodSettings", this.methodSettings()).add("Variables", this.variables()).add("DocumentationVersion", (Object)this.documentationVersion()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "clientCertificateId": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateId()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "cacheClusterEnabled": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterEnabled()));
            }
            case "cacheClusterSize": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterSize()));
            }
            case "cacheClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterStatusAsString()));
            }
            case "methodSettings": {
                return Optional.ofNullable(clazz.cast(this.methodSettings()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "documentationVersion": {
                return Optional.ofNullable(clazz.cast(this.documentationVersion()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String deploymentId;
        private String clientCertificateId;
        private String stageName;
        private String description;
        private Boolean cacheClusterEnabled;
        private String cacheClusterSize;
        private String cacheClusterStatus;
        private Map<String, MethodSetting> methodSettings = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();
        private String documentationVersion;
        private Instant createdDate;
        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStageResponse model) {
            super(model);
            this.deploymentId(model.deploymentId);
            this.clientCertificateId(model.clientCertificateId);
            this.stageName(model.stageName);
            this.description(model.description);
            this.cacheClusterEnabled(model.cacheClusterEnabled);
            this.cacheClusterSize(model.cacheClusterSize);
            this.cacheClusterStatus(model.cacheClusterStatus);
            this.methodSettings(model.methodSettings);
            this.variables(model.variables);
            this.documentationVersion(model.documentationVersion);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getClientCertificateId() {
            return this.clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        public final String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        public final String getCacheClusterStatus() {
            return this.cacheClusterStatus;
        }

        @Override
        public final Builder cacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
            return this;
        }

        @Override
        public final Builder cacheClusterStatus(CacheClusterStatus cacheClusterStatus) {
            this.cacheClusterStatus(cacheClusterStatus.toString());
            return this;
        }

        public final void setCacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
        }

        public final Map<String, MethodSetting.Builder> getMethodSettings() {
            return this.methodSettings != null ? CollectionUtils.mapValues(this.methodSettings, MethodSetting::toBuilder) : null;
        }

        @Override
        public final Builder methodSettings(Map<String, MethodSetting> methodSettings) {
            this.methodSettings = MapOfMethodSettingsCopier.copy(methodSettings);
            return this;
        }

        public final void setMethodSettings(Map<String, MethodSetting.BuilderImpl> methodSettings) {
            this.methodSettings = MapOfMethodSettingsCopier.copyFromBuilder(methodSettings);
        }

        public final Map<String, String> getVariables() {
            return this.variables;
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
            return this;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = MapOfStringToStringCopier.copy(variables);
        }

        public final String getDocumentationVersion() {
            return this.documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public GetStageResponse build() {
            return new GetStageResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetStageResponse> {
        public Builder deploymentId(String var1);

        public Builder clientCertificateId(String var1);

        public Builder stageName(String var1);

        public Builder description(String var1);

        public Builder cacheClusterEnabled(Boolean var1);

        public Builder cacheClusterSize(String var1);

        public Builder cacheClusterStatus(String var1);

        public Builder cacheClusterStatus(CacheClusterStatus var1);

        public Builder methodSettings(Map<String, MethodSetting> var1);

        public Builder variables(Map<String, String> var1);

        public Builder documentationVersion(String var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);
    }
}

