/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.EndpointConfiguration;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRestApiResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetRestApiResponse> {
    private final String id;
    private final String name;
    private final String description;
    private final Instant createdDate;
    private final String version;
    private final List<String> warnings;
    private final List<String> binaryMediaTypes;
    private final EndpointConfiguration endpointConfiguration;

    private GetRestApiResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.version = builder.version;
        this.warnings = builder.warnings;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.endpointConfiguration = builder.endpointConfiguration;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String version() {
        return this.version;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public List<String> binaryMediaTypes() {
        return this.binaryMediaTypes;
    }

    public EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryMediaTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRestApiResponse)) {
            return false;
        }
        GetRestApiResponse other = (GetRestApiResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.binaryMediaTypes(), other.binaryMediaTypes()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"GetRestApiResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreatedDate", (Object)this.createdDate()).add("Version", (Object)this.version()).add("Warnings", this.warnings()).add("BinaryMediaTypes", this.binaryMediaTypes()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "binaryMediaTypes": {
                return Optional.ofNullable(clazz.cast(this.binaryMediaTypes()));
            }
            case "endpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String description;
        private Instant createdDate;
        private String version;
        private List<String> warnings = DefaultSdkAutoConstructList.getInstance();
        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();
        private EndpointConfiguration endpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRestApiResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.createdDate(model.createdDate);
            this.version(model.version);
            this.warnings(model.warnings);
            this.binaryMediaTypes(model.binaryMediaTypes);
            this.endpointConfiguration(model.endpointConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Collection<String> getWarnings() {
            return this.warnings;
        }

        @Override
        public final Builder warnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(String ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        public final void setWarnings(Collection<String> warnings) {
            this.warnings = ListOfStringCopier.copy(warnings);
        }

        public final Collection<String> getBinaryMediaTypes() {
            return this.binaryMediaTypes;
        }

        @Override
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryMediaTypes(String ... binaryMediaTypes) {
            this.binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public GetRestApiResponse build() {
            return new GetRestApiResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetRestApiResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder createdDate(Instant var1);

        public Builder version(String var1);

        public Builder warnings(Collection<String> var1);

        public Builder warnings(String ... var1);

        public Builder binaryMediaTypes(Collection<String> var1);

        public Builder binaryMediaTypes(String ... var1);

        public Builder endpointConfiguration(EndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }
    }
}

