/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToBooleanCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMethodResponseResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetMethodResponseResponse> {
    private final String statusCode;
    private final Map<String, Boolean> responseParameters;
    private final Map<String, String> responseModels;

    private GetMethodResponseResponse(BuilderImpl builder) {
        super(builder);
        this.statusCode = builder.statusCode;
        this.responseParameters = builder.responseParameters;
        this.responseModels = builder.responseModels;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public Map<String, Boolean> responseParameters() {
        return this.responseParameters;
    }

    public Map<String, String> responseModels() {
        return this.responseModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseModels());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMethodResponseResponse)) {
            return false;
        }
        GetMethodResponseResponse other = (GetMethodResponseResponse)((Object)obj);
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.responseParameters(), other.responseParameters()) && Objects.equals(this.responseModels(), other.responseModels());
    }

    public String toString() {
        return ToString.builder((String)"GetMethodResponseResponse").add("StatusCode", (Object)this.statusCode()).add("ResponseParameters", this.responseParameters()).add("ResponseModels", this.responseModels()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "responseParameters": {
                return Optional.ofNullable(clazz.cast(this.responseParameters()));
            }
            case "responseModels": {
                return Optional.ofNullable(clazz.cast(this.responseModels()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String statusCode;
        private Map<String, Boolean> responseParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMethodResponseResponse model) {
            super(model);
            this.statusCode(model.statusCode);
            this.responseParameters(model.responseParameters);
            this.responseModels(model.responseModels);
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final Map<String, Boolean> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final Builder responseParameters(Map<String, Boolean> responseParameters) {
            this.responseParameters = MapOfStringToBooleanCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, Boolean> responseParameters) {
            this.responseParameters = MapOfStringToBooleanCopier.copy(responseParameters);
        }

        public final Map<String, String> getResponseModels() {
            return this.responseModels;
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = MapOfStringToStringCopier.copy(responseModels);
            return this;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = MapOfStringToStringCopier.copy(responseModels);
        }

        @Override
        public GetMethodResponseResponse build() {
            return new GetMethodResponseResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetMethodResponseResponse> {
        public Builder statusCode(String var1);

        public Builder responseParameters(Map<String, Boolean> var1);

        public Builder responseModels(Map<String, String> var1);
    }
}

