/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ContentHandlingStrategy;
import software.amazon.awssdk.services.apigateway.model.IntegrationResponse;
import software.amazon.awssdk.services.apigateway.model.IntegrationType;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfIntegrationResponseCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIntegrationResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetIntegrationResponse> {
    private final String type;
    private final String httpMethod;
    private final String uri;
    private final String credentials;
    private final Map<String, String> requestParameters;
    private final Map<String, String> requestTemplates;
    private final String passthroughBehavior;
    private final String contentHandling;
    private final String cacheNamespace;
    private final List<String> cacheKeyParameters;
    private final Map<String, IntegrationResponse> integrationResponses;

    private GetIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.httpMethod = builder.httpMethod;
        this.uri = builder.uri;
        this.credentials = builder.credentials;
        this.requestParameters = builder.requestParameters;
        this.requestTemplates = builder.requestTemplates;
        this.passthroughBehavior = builder.passthroughBehavior;
        this.contentHandling = builder.contentHandling;
        this.cacheNamespace = builder.cacheNamespace;
        this.cacheKeyParameters = builder.cacheKeyParameters;
        this.integrationResponses = builder.integrationResponses;
    }

    public IntegrationType type() {
        return IntegrationType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String uri() {
        return this.uri;
    }

    public String credentials() {
        return this.credentials;
    }

    public Map<String, String> requestParameters() {
        return this.requestParameters;
    }

    public Map<String, String> requestTemplates() {
        return this.requestTemplates;
    }

    public String passthroughBehavior() {
        return this.passthroughBehavior;
    }

    public ContentHandlingStrategy contentHandling() {
        return ContentHandlingStrategy.fromValue(this.contentHandling);
    }

    public String contentHandlingAsString() {
        return this.contentHandling;
    }

    public String cacheNamespace() {
        return this.cacheNamespace;
    }

    public List<String> cacheKeyParameters() {
        return this.cacheKeyParameters;
    }

    public Map<String, IntegrationResponse> integrationResponses() {
        return this.integrationResponses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.passthroughBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheKeyParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationResponses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntegrationResponse)) {
            return false;
        }
        GetIntegrationResponse other = (GetIntegrationResponse)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.requestParameters(), other.requestParameters()) && Objects.equals(this.requestTemplates(), other.requestTemplates()) && Objects.equals(this.passthroughBehavior(), other.passthroughBehavior()) && Objects.equals(this.contentHandlingAsString(), other.contentHandlingAsString()) && Objects.equals(this.cacheNamespace(), other.cacheNamespace()) && Objects.equals(this.cacheKeyParameters(), other.cacheKeyParameters()) && Objects.equals(this.integrationResponses(), other.integrationResponses());
    }

    public String toString() {
        return ToString.builder((String)"GetIntegrationResponse").add("Type", (Object)this.typeAsString()).add("HttpMethod", (Object)this.httpMethod()).add("Uri", (Object)this.uri()).add("Credentials", (Object)this.credentials()).add("RequestParameters", this.requestParameters()).add("RequestTemplates", this.requestTemplates()).add("PassthroughBehavior", (Object)this.passthroughBehavior()).add("ContentHandling", (Object)this.contentHandlingAsString()).add("CacheNamespace", (Object)this.cacheNamespace()).add("CacheKeyParameters", this.cacheKeyParameters()).add("IntegrationResponses", this.integrationResponses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "requestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "requestTemplates": {
                return Optional.ofNullable(clazz.cast(this.requestTemplates()));
            }
            case "passthroughBehavior": {
                return Optional.ofNullable(clazz.cast(this.passthroughBehavior()));
            }
            case "contentHandling": {
                return Optional.ofNullable(clazz.cast(this.contentHandlingAsString()));
            }
            case "cacheNamespace": {
                return Optional.ofNullable(clazz.cast(this.cacheNamespace()));
            }
            case "cacheKeyParameters": {
                return Optional.ofNullable(clazz.cast(this.cacheKeyParameters()));
            }
            case "integrationResponses": {
                return Optional.ofNullable(clazz.cast(this.integrationResponses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String type;
        private String httpMethod;
        private String uri;
        private String credentials;
        private Map<String, String> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestTemplates = DefaultSdkAutoConstructMap.getInstance();
        private String passthroughBehavior;
        private String contentHandling;
        private String cacheNamespace;
        private List<String> cacheKeyParameters = DefaultSdkAutoConstructList.getInstance();
        private Map<String, IntegrationResponse> integrationResponses = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntegrationResponse model) {
            super(model);
            this.type(model.type);
            this.httpMethod(model.httpMethod);
            this.uri(model.uri);
            this.credentials(model.credentials);
            this.requestParameters(model.requestParameters);
            this.requestTemplates(model.requestTemplates);
            this.passthroughBehavior(model.passthroughBehavior);
            this.contentHandling(model.contentHandling);
            this.cacheNamespace(model.cacheNamespace);
            this.cacheKeyParameters(model.cacheKeyParameters);
            this.integrationResponses(model.integrationResponses);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IntegrationType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getCredentials() {
            return this.credentials;
        }

        @Override
        public final Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(String credentials) {
            this.credentials = credentials;
        }

        public final Map<String, String> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, String> requestParameters) {
            this.requestParameters = MapOfStringToStringCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, String> requestParameters) {
            this.requestParameters = MapOfStringToStringCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public final Builder requestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = MapOfStringToStringCopier.copy(requestTemplates);
            return this;
        }

        public final void setRequestTemplates(Map<String, String> requestTemplates) {
            this.requestTemplates = MapOfStringToStringCopier.copy(requestTemplates);
        }

        public final String getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final Builder passthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        public final void setPassthroughBehavior(String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
        }

        public final String getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final Builder contentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        @Override
        public final Builder contentHandling(ContentHandlingStrategy contentHandling) {
            this.contentHandling(contentHandling.toString());
            return this;
        }

        public final void setContentHandling(String contentHandling) {
            this.contentHandling = contentHandling;
        }

        public final String getCacheNamespace() {
            return this.cacheNamespace;
        }

        @Override
        public final Builder cacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        public final void setCacheNamespace(String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
        }

        public final Collection<String> getCacheKeyParameters() {
            return this.cacheKeyParameters;
        }

        @Override
        public final Builder cacheKeyParameters(Collection<String> cacheKeyParameters) {
            this.cacheKeyParameters = ListOfStringCopier.copy(cacheKeyParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheKeyParameters(String ... cacheKeyParameters) {
            this.cacheKeyParameters(Arrays.asList(cacheKeyParameters));
            return this;
        }

        public final void setCacheKeyParameters(Collection<String> cacheKeyParameters) {
            this.cacheKeyParameters = ListOfStringCopier.copy(cacheKeyParameters);
        }

        public final Map<String, IntegrationResponse.Builder> getIntegrationResponses() {
            return this.integrationResponses != null ? CollectionUtils.mapValues(this.integrationResponses, IntegrationResponse::toBuilder) : null;
        }

        @Override
        public final Builder integrationResponses(Map<String, IntegrationResponse> integrationResponses) {
            this.integrationResponses = MapOfIntegrationResponseCopier.copy(integrationResponses);
            return this;
        }

        public final void setIntegrationResponses(Map<String, IntegrationResponse.BuilderImpl> integrationResponses) {
            this.integrationResponses = MapOfIntegrationResponseCopier.copyFromBuilder(integrationResponses);
        }

        @Override
        public GetIntegrationResponse build() {
            return new GetIntegrationResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetIntegrationResponse> {
        public Builder type(String var1);

        public Builder type(IntegrationType var1);

        public Builder httpMethod(String var1);

        public Builder uri(String var1);

        public Builder credentials(String var1);

        public Builder requestParameters(Map<String, String> var1);

        public Builder requestTemplates(Map<String, String> var1);

        public Builder passthroughBehavior(String var1);

        public Builder contentHandling(String var1);

        public Builder contentHandling(ContentHandlingStrategy var1);

        public Builder cacheNamespace(String var1);

        public Builder cacheKeyParameters(Collection<String> var1);

        public Builder cacheKeyParameters(String ... var1);

        public Builder integrationResponses(Map<String, IntegrationResponse> var1);
    }
}

