/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApiKeysRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, GetApiKeysRequest> {
    private final String position;
    private final Integer limit;
    private final String nameQuery;
    private final String customerId;
    private final Boolean includeValues;

    private GetApiKeysRequest(BuilderImpl builder) {
        super(builder);
        this.position = builder.position;
        this.limit = builder.limit;
        this.nameQuery = builder.nameQuery;
        this.customerId = builder.customerId;
        this.includeValues = builder.includeValues;
    }

    public String position() {
        return this.position;
    }

    public Integer limit() {
        return this.limit;
    }

    public String nameQuery() {
        return this.nameQuery;
    }

    public String customerId() {
        return this.customerId;
    }

    public Boolean includeValues() {
        return this.includeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiKeysRequest)) {
            return false;
        }
        GetApiKeysRequest other = (GetApiKeysRequest)((Object)obj);
        return Objects.equals(this.position(), other.position()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nameQuery(), other.nameQuery()) && Objects.equals(this.customerId(), other.customerId()) && Objects.equals(this.includeValues(), other.includeValues());
    }

    public String toString() {
        return ToString.builder((String)"GetApiKeysRequest").add("Position", (Object)this.position()).add("Limit", (Object)this.limit()).add("NameQuery", (Object)this.nameQuery()).add("CustomerId", (Object)this.customerId()).add("IncludeValues", (Object)this.includeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "nameQuery": {
                return Optional.ofNullable(clazz.cast(this.nameQuery()));
            }
            case "customerId": {
                return Optional.ofNullable(clazz.cast(this.customerId()));
            }
            case "includeValues": {
                return Optional.ofNullable(clazz.cast(this.includeValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String position;
        private Integer limit;
        private String nameQuery;
        private String customerId;
        private Boolean includeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiKeysRequest model) {
            super(model);
            this.position(model.position);
            this.limit(model.limit);
            this.nameQuery(model.nameQuery);
            this.customerId(model.customerId);
            this.includeValues(model.includeValues);
        }

        public final String getPosition() {
            return this.position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getNameQuery() {
            return this.nameQuery;
        }

        @Override
        public final Builder nameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
            return this;
        }

        public final void setNameQuery(String nameQuery) {
            this.nameQuery = nameQuery;
        }

        public final String getCustomerId() {
            return this.customerId;
        }

        @Override
        public final Builder customerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public final void setCustomerId(String customerId) {
            this.customerId = customerId;
        }

        public final Boolean getIncludeValues() {
            return this.includeValues;
        }

        @Override
        public final Builder includeValues(Boolean includeValues) {
            this.includeValues = includeValues;
            return this;
        }

        public final void setIncludeValues(Boolean includeValues) {
            this.includeValues = includeValues;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApiKeysRequest build() {
            return new GetApiKeysRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, GetApiKeysRequest> {
        public Builder position(String var1);

        public Builder limit(Integer var1);

        public Builder nameQuery(String var1);

        public Builder customerId(String var1);

        public Builder includeValues(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

