/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.ThrottleSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, GetAccountResponse> {
    private final String cloudwatchRoleArn;
    private final ThrottleSettings throttleSettings;
    private final List<String> features;
    private final String apiKeyVersion;

    private GetAccountResponse(BuilderImpl builder) {
        super(builder);
        this.cloudwatchRoleArn = builder.cloudwatchRoleArn;
        this.throttleSettings = builder.throttleSettings;
        this.features = builder.features;
        this.apiKeyVersion = builder.apiKeyVersion;
    }

    public String cloudwatchRoleArn() {
        return this.cloudwatchRoleArn;
    }

    public ThrottleSettings throttleSettings() {
        return this.throttleSettings;
    }

    public List<String> features() {
        return this.features;
    }

    public String apiKeyVersion() {
        return this.apiKeyVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.throttleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.features());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountResponse)) {
            return false;
        }
        GetAccountResponse other = (GetAccountResponse)((Object)obj);
        return Objects.equals(this.cloudwatchRoleArn(), other.cloudwatchRoleArn()) && Objects.equals(this.throttleSettings(), other.throttleSettings()) && Objects.equals(this.features(), other.features()) && Objects.equals(this.apiKeyVersion(), other.apiKeyVersion());
    }

    public String toString() {
        return ToString.builder((String)"GetAccountResponse").add("CloudwatchRoleArn", (Object)this.cloudwatchRoleArn()).add("ThrottleSettings", (Object)this.throttleSettings()).add("Features", this.features()).add("ApiKeyVersion", (Object)this.apiKeyVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudwatchRoleArn": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchRoleArn()));
            }
            case "throttleSettings": {
                return Optional.ofNullable(clazz.cast(this.throttleSettings()));
            }
            case "features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
            case "apiKeyVersion": {
                return Optional.ofNullable(clazz.cast(this.apiKeyVersion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String cloudwatchRoleArn;
        private ThrottleSettings throttleSettings;
        private List<String> features = DefaultSdkAutoConstructList.getInstance();
        private String apiKeyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountResponse model) {
            super(model);
            this.cloudwatchRoleArn(model.cloudwatchRoleArn);
            this.throttleSettings(model.throttleSettings);
            this.features(model.features);
            this.apiKeyVersion(model.apiKeyVersion);
        }

        public final String getCloudwatchRoleArn() {
            return this.cloudwatchRoleArn;
        }

        @Override
        public final Builder cloudwatchRoleArn(String cloudwatchRoleArn) {
            this.cloudwatchRoleArn = cloudwatchRoleArn;
            return this;
        }

        public final void setCloudwatchRoleArn(String cloudwatchRoleArn) {
            this.cloudwatchRoleArn = cloudwatchRoleArn;
        }

        public final ThrottleSettings.Builder getThrottleSettings() {
            return this.throttleSettings != null ? this.throttleSettings.toBuilder() : null;
        }

        @Override
        public final Builder throttleSettings(ThrottleSettings throttleSettings) {
            this.throttleSettings = throttleSettings;
            return this;
        }

        public final void setThrottleSettings(ThrottleSettings.BuilderImpl throttleSettings) {
            this.throttleSettings = throttleSettings != null ? throttleSettings.build() : null;
        }

        public final Collection<String> getFeatures() {
            return this.features;
        }

        @Override
        public final Builder features(Collection<String> features) {
            this.features = ListOfStringCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(String ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        public final void setFeatures(Collection<String> features) {
            this.features = ListOfStringCopier.copy(features);
        }

        public final String getApiKeyVersion() {
            return this.apiKeyVersion;
        }

        @Override
        public final Builder apiKeyVersion(String apiKeyVersion) {
            this.apiKeyVersion = apiKeyVersion;
            return this;
        }

        public final void setApiKeyVersion(String apiKeyVersion) {
            this.apiKeyVersion = apiKeyVersion;
        }

        @Override
        public GetAccountResponse build() {
            return new GetAccountResponse(this);
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    CopyableBuilder<Builder, GetAccountResponse> {
        public Builder cloudwatchRoleArn(String var1);

        public Builder throttleSettings(ThrottleSettings var1);

        default public Builder throttleSettings(Consumer<ThrottleSettings.Builder> throttleSettings) {
            return this.throttleSettings((ThrottleSettings)((ThrottleSettings.Builder)ThrottleSettings.builder().applyMutation(throttleSettings)).build());
        }

        public Builder features(Collection<String> var1);

        public Builder features(String ... var1);

        public Builder apiKeyVersion(String var1);
    }
}

