/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EndpointType {
    REGIONAL("REGIONAL"),
    EDGE("EDGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EndpointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EndpointType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointType> knownValues() {
        return Stream.of(EndpointType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

