/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.DocumentationVersionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentationVersion
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentationVersion> {
    private final String version;
    private final Instant createdDate;
    private final String description;

    private DocumentationVersion(BuilderImpl builder) {
        this.version = builder.version;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
    }

    public String version() {
        return this.version;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentationVersion)) {
            return false;
        }
        DocumentationVersion other = (DocumentationVersion)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"DocumentationVersion").add("Version", (Object)this.version()).add("CreatedDate", (Object)this.createdDate()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentationVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private Instant createdDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentationVersion model) {
            this.version(model.version);
            this.createdDate(model.createdDate);
            this.description(model.description);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public DocumentationVersion build() {
            return new DocumentationVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentationVersion> {
        public Builder version(String var1);

        public Builder createdDate(Instant var1);

        public Builder description(String var1);
    }
}

