/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.EndpointConfiguration;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRestApiRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateRestApiRequest> {
    private final String name;
    private final String description;
    private final String version;
    private final String cloneFrom;
    private final List<String> binaryMediaTypes;
    private final EndpointConfiguration endpointConfiguration;

    private CreateRestApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.version = builder.version;
        this.cloneFrom = builder.cloneFrom;
        this.binaryMediaTypes = builder.binaryMediaTypes;
        this.endpointConfiguration = builder.endpointConfiguration;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String version() {
        return this.version;
    }

    public String cloneFrom() {
        return this.cloneFrom;
    }

    public List<String> binaryMediaTypes() {
        return this.binaryMediaTypes;
    }

    public EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloneFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryMediaTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestApiRequest)) {
            return false;
        }
        CreateRestApiRequest other = (CreateRestApiRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.cloneFrom(), other.cloneFrom()) && Objects.equals(this.binaryMediaTypes(), other.binaryMediaTypes()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateRestApiRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Version", (Object)this.version()).add("CloneFrom", (Object)this.cloneFrom()).add("BinaryMediaTypes", this.binaryMediaTypes()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "cloneFrom": {
                return Optional.ofNullable(clazz.cast(this.cloneFrom()));
            }
            case "binaryMediaTypes": {
                return Optional.ofNullable(clazz.cast(this.binaryMediaTypes()));
            }
            case "endpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String version;
        private String cloneFrom;
        private List<String> binaryMediaTypes = DefaultSdkAutoConstructList.getInstance();
        private EndpointConfiguration endpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestApiRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.version(model.version);
            this.cloneFrom(model.cloneFrom);
            this.binaryMediaTypes(model.binaryMediaTypes);
            this.endpointConfiguration(model.endpointConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getCloneFrom() {
            return this.cloneFrom;
        }

        @Override
        public final Builder cloneFrom(String cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        public final void setCloneFrom(String cloneFrom) {
            this.cloneFrom = cloneFrom;
        }

        public final Collection<String> getBinaryMediaTypes() {
            return this.binaryMediaTypes;
        }

        @Override
        public final Builder binaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryMediaTypes(String ... binaryMediaTypes) {
            this.binaryMediaTypes(Arrays.asList(binaryMediaTypes));
            return this;
        }

        public final void setBinaryMediaTypes(Collection<String> binaryMediaTypes) {
            this.binaryMediaTypes = ListOfStringCopier.copy(binaryMediaTypes);
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRestApiRequest build() {
            return new CreateRestApiRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, CreateRestApiRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder version(String var1);

        public Builder cloneFrom(String var1);

        public Builder binaryMediaTypes(Collection<String> var1);

        public Builder binaryMediaTypes(String ... var1);

        public Builder endpointConfiguration(EndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

