/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.EndpointConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainNameRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, CreateDomainNameRequest> {
    private final String domainName;
    private final String certificateName;
    private final String certificateBody;
    private final String certificatePrivateKey;
    private final String certificateChain;
    private final String certificateArn;
    private final String regionalCertificateName;
    private final String regionalCertificateArn;
    private final EndpointConfiguration endpointConfiguration;

    private CreateDomainNameRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.certificateName = builder.certificateName;
        this.certificateBody = builder.certificateBody;
        this.certificatePrivateKey = builder.certificatePrivateKey;
        this.certificateChain = builder.certificateChain;
        this.certificateArn = builder.certificateArn;
        this.regionalCertificateName = builder.regionalCertificateName;
        this.regionalCertificateArn = builder.regionalCertificateArn;
        this.endpointConfiguration = builder.endpointConfiguration;
    }

    public String domainName() {
        return this.domainName;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public String certificateBody() {
        return this.certificateBody;
    }

    public String certificatePrivateKey() {
        return this.certificatePrivateKey;
    }

    public String certificateChain() {
        return this.certificateChain;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String regionalCertificateName() {
        return this.regionalCertificateName;
    }

    public String regionalCertificateArn() {
        return this.regionalCertificateArn;
    }

    public EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePrivateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainNameRequest)) {
            return false;
        }
        CreateDomainNameRequest other = (CreateDomainNameRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.certificateBody(), other.certificateBody()) && Objects.equals(this.certificatePrivateKey(), other.certificatePrivateKey()) && Objects.equals(this.certificateChain(), other.certificateChain()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.regionalCertificateName(), other.regionalCertificateName()) && Objects.equals(this.regionalCertificateArn(), other.regionalCertificateArn()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateDomainNameRequest").add("DomainName", (Object)this.domainName()).add("CertificateName", (Object)this.certificateName()).add("CertificateBody", (Object)this.certificateBody()).add("CertificatePrivateKey", (Object)this.certificatePrivateKey()).add("CertificateChain", (Object)this.certificateChain()).add("CertificateArn", (Object)this.certificateArn()).add("RegionalCertificateName", (Object)this.regionalCertificateName()).add("RegionalCertificateArn", (Object)this.regionalCertificateArn()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "certificateBody": {
                return Optional.ofNullable(clazz.cast(this.certificateBody()));
            }
            case "certificatePrivateKey": {
                return Optional.ofNullable(clazz.cast(this.certificatePrivateKey()));
            }
            case "certificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "regionalCertificateName": {
                return Optional.ofNullable(clazz.cast(this.regionalCertificateName()));
            }
            case "regionalCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.regionalCertificateArn()));
            }
            case "endpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String certificateName;
        private String certificateBody;
        private String certificatePrivateKey;
        private String certificateChain;
        private String certificateArn;
        private String regionalCertificateName;
        private String regionalCertificateArn;
        private EndpointConfiguration endpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainNameRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.certificateName(model.certificateName);
            this.certificateBody(model.certificateBody);
            this.certificatePrivateKey(model.certificatePrivateKey);
            this.certificateChain(model.certificateChain);
            this.certificateArn(model.certificateArn);
            this.regionalCertificateName(model.regionalCertificateName);
            this.regionalCertificateArn(model.regionalCertificateArn);
            this.endpointConfiguration(model.endpointConfiguration);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getCertificateBody() {
            return this.certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        public final String getCertificatePrivateKey() {
            return this.certificatePrivateKey;
        }

        @Override
        public final Builder certificatePrivateKey(String certificatePrivateKey) {
            this.certificatePrivateKey = certificatePrivateKey;
            return this;
        }

        public final void setCertificatePrivateKey(String certificatePrivateKey) {
            this.certificatePrivateKey = certificatePrivateKey;
        }

        public final String getCertificateChain() {
            return this.certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getRegionalCertificateName() {
            return this.regionalCertificateName;
        }

        @Override
        public final Builder regionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
            return this;
        }

        public final void setRegionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
        }

        public final String getRegionalCertificateArn() {
            return this.regionalCertificateArn;
        }

        @Override
        public final Builder regionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
            return this;
        }

        public final void setRegionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainNameRequest build() {
            return new CreateDomainNameRequest(this);
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    CopyableBuilder<Builder, CreateDomainNameRequest> {
        public Builder domainName(String var1);

        public Builder certificateName(String var1);

        public Builder certificateBody(String var1);

        public Builder certificatePrivateKey(String var1);

        public Builder certificateChain(String var1);

        public Builder certificateArn(String var1);

        public Builder regionalCertificateName(String var1);

        public Builder regionalCertificateArn(String var1);

        public Builder endpointConfiguration(EndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

