/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.apigateway.transform.ApiStageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiStage
implements StructuredPojo,
ToCopyableBuilder<Builder, ApiStage> {
    private final String apiId;
    private final String stage;

    private ApiStage(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.stage = builder.stage;
    }

    public String apiId() {
        return this.apiId;
    }

    public String stage() {
        return this.stage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiStage)) {
            return false;
        }
        ApiStage other = (ApiStage)obj;
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.stage(), other.stage());
    }

    public String toString() {
        return ToString.builder((String)"ApiStage").add("ApiId", (Object)this.apiId()).add("Stage", (Object)this.stage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApiStageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiId;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiStage model) {
            this.apiId(model.apiId);
            this.stage(model.stage);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getStage() {
            return this.stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public ApiStage build() {
            return new ApiStage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApiStage> {
        public Builder apiId(String var1);

        public Builder stage(String var1);
    }
}

